/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.command;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Environment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class GpUtils {
    private static int[] p0;
    private static int[] p1;
    private static int[] p2;
    private static int[] p3;
    private static int[] p4;
    private static int[] p5;
    private static int[] p6;
    private static int[][] Floyd16x16;
    private static int[][] Floyd8x8;
    public static final int ALGORITHM_DITHER_16x16 = 16;
    public static final int ALGORITHM_DITHER_8x8 = 8;
    public static final int ALGORITHM_TEXTMODE = 2;
    public static final int ALGORITHM_GRAYTEXTMODE = 1;

    static {
        int[] nArray = new int[2];
        nArray[1] = 128;
        p0 = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 64;
        p1 = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 32;
        p2 = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = 16;
        p3 = nArray4;
        int[] nArray5 = new int[2];
        nArray5[1] = 8;
        p4 = nArray5;
        int[] nArray6 = new int[2];
        nArray6[1] = 4;
        p5 = nArray6;
        int[] nArray7 = new int[2];
        nArray7[1] = 2;
        p6 = nArray7;
        int[][] nArrayArray = new int[16][];
        int[] nArray8 = new int[16];
        nArray8[1] = 128;
        nArray8[2] = 32;
        nArray8[3] = 160;
        nArray8[4] = 8;
        nArray8[5] = 136;
        nArray8[6] = 40;
        nArray8[7] = 168;
        nArray8[8] = 2;
        nArray8[9] = 130;
        nArray8[10] = 34;
        nArray8[11] = 162;
        nArray8[12] = 10;
        nArray8[13] = 138;
        nArray8[14] = 42;
        nArray8[15] = 170;
        nArrayArray[0] = nArray8;
        nArrayArray[1] = new int[]{192, 64, 224, 96, 200, 72, 232, 104, 194, 66, 226, 98, 202, 74, 234, 106};
        nArrayArray[2] = new int[]{48, 176, 16, 144, 56, 184, 24, 152, 50, 178, 18, 146, 58, 186, 26, 154};
        nArrayArray[3] = new int[]{240, 112, 208, 80, 248, 120, 216, 88, 242, 114, 210, 82, 250, 122, 218, 90};
        nArrayArray[4] = new int[]{12, 140, 44, 172, 4, 132, 36, 164, 14, 142, 46, 174, 6, 134, 38, 166};
        nArrayArray[5] = new int[]{204, 76, 236, 108, 196, 68, 228, 100, 206, 78, 238, 110, 198, 70, 230, 102};
        nArrayArray[6] = new int[]{60, 188, 28, 156, 52, 180, 20, 148, 62, 190, 30, 158, 54, 182, 22, 150};
        nArrayArray[7] = new int[]{252, 124, 220, 92, 244, 116, 212, 84, 254, 126, 222, 94, 246, 118, 214, 86};
        nArrayArray[8] = new int[]{3, 131, 35, 163, 11, 139, 43, 171, 1, 129, 33, 161, 9, 137, 41, 169};
        nArrayArray[9] = new int[]{195, 67, 227, 99, 203, 75, 235, 107, 193, 65, 225, 97, 201, 73, 233, 105};
        nArrayArray[10] = new int[]{51, 179, 19, 147, 59, 187, 27, 155, 49, 177, 17, 145, 57, 185, 25, 153};
        nArrayArray[11] = new int[]{243, 115, 211, 83, 251, 123, 219, 91, 241, 113, 209, 81, 249, 121, 217, 89};
        nArrayArray[12] = new int[]{15, 143, 47, 175, 7, 135, 39, 167, 13, 141, 45, 173, 5, 133, 37, 165};
        nArrayArray[13] = new int[]{207, 79, 239, 111, 199, 71, 231, 103, 205, 77, 237, 109, 197, 69, 229, 101};
        nArrayArray[14] = new int[]{63, 191, 31, 159, 55, 183, 23, 151, 61, 189, 29, 157, 53, 181, 21, 149};
        nArrayArray[15] = new int[]{254, 127, 223, 95, 247, 119, 215, 87, 253, 125, 221, 93, 245, 117, 213, 85};
        Floyd16x16 = nArrayArray;
        int[][] nArrayArray2 = new int[8][];
        int[] nArray9 = new int[8];
        nArray9[1] = 32;
        nArray9[2] = 8;
        nArray9[3] = 40;
        nArray9[4] = 2;
        nArray9[5] = 34;
        nArray9[6] = 10;
        nArray9[7] = 42;
        nArrayArray2[0] = nArray9;
        nArrayArray2[1] = new int[]{48, 16, 56, 24, 50, 18, 58, 26};
        nArrayArray2[2] = new int[]{12, 44, 4, 36, 14, 46, 6, 38};
        nArrayArray2[3] = new int[]{60, 28, 52, 20, 62, 30, 54, 22};
        nArrayArray2[4] = new int[]{3, 35, 11, 43, 1, 33, 9, 41};
        nArrayArray2[5] = new int[]{51, 19, 59, 27, 49, 17, 57, 25};
        nArrayArray2[6] = new int[]{15, 47, 7, 39, 13, 45, 5, 37};
        nArrayArray2[7] = new int[]{63, 31, 55, 23, 61, 29, 53, 21};
        Floyd8x8 = nArrayArray2;
    }

    public static Bitmap resizeImage(Bitmap bitmap, int w, int h) {
        Bitmap BitmapOrg = bitmap;
        int width = BitmapOrg.getWidth();
        int height = BitmapOrg.getHeight();
        int newWidth = w;
        int newHeight = h;
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)BitmapOrg, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public static void saveMyBitmap(Bitmap mBitmap) {
        File f = new File(Environment.getExternalStorageDirectory().getPath(), "Btatotest.jpeg");
        try {
            f.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(f);
            mBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fOut);
            fOut.flush();
            fOut.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Bitmap toGrayscale(Bitmap bmpOriginal) {
        int height = bmpOriginal.getHeight();
        int width = bmpOriginal.getWidth();
        Bitmap bmpGrayscale = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas c = new Canvas(bmpGrayscale);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        paint.setColorFilter((ColorFilter)f);
        c.drawBitmap(bmpOriginal, 0.0f, 0.0f, paint);
        return bmpGrayscale;
    }

    static byte[] pixToEscRastBitImageCmd(byte[] src, int nWidth, int nMode) {
        int nHeight = src.length / nWidth;
        byte[] data = new byte[8 + src.length / 8];
        data[0] = 29;
        data[1] = 118;
        data[2] = 48;
        data[3] = (byte)(nMode & 1);
        data[4] = (byte)(nWidth / 8 % 256);
        data[5] = (byte)(nWidth / 8 / 256);
        data[6] = (byte)(nHeight % 256);
        data[7] = (byte)(nHeight / 256);
        int i = 8;
        int k = 0;
        while (i < data.length) {
            data[i] = (byte)(p0[src[k]] + p1[src[k + 1]] + p2[src[k + 2]] + p3[src[k + 3]] + p4[src[k + 4]] + p5[src[k + 5]] + p6[src[k + 6]] + src[k + 7]);
            k += 8;
            ++i;
        }
        return data;
    }

    static byte[] pixToEscRastBitImageCmd(byte[] src) {
        byte[] data = new byte[src.length / 8];
        int i = 0;
        int k = 0;
        while (i < data.length) {
            data[i] = (byte)(p0[src[k]] + p1[src[k + 1]] + p2[src[k + 2]] + p3[src[k + 3]] + p4[src[k + 4]] + p5[src[k + 5]] + p6[src[k + 6]] + src[k + 7]);
            k += 8;
            ++i;
        }
        return data;
    }

    static byte[] pixToEscNvBitImageCmd(byte[] src, int width, int height) {
        byte[] data = new byte[src.length / 8 + 4];
        data[0] = (byte)(width / 8 % 256);
        data[1] = (byte)(width / 8 / 256);
        data[2] = (byte)(height / 8 % 256);
        data[3] = (byte)(height / 8 / 256);
        int k = 0;
        int i = 0;
        while (i < width) {
            k = 0;
            int j = 0;
            while (j < height / 8) {
                data[4 + j + i * height / 8] = (byte)(p0[src[i + k]] + p1[src[i + k + 1 * width]] + p2[src[i + k + 2 * width]] + p3[src[i + k + 3 * width]] + p4[src[i + k + 4 * width]] + p5[src[i + k + 5 * width]] + p6[src[i + k + 6 * width]] + src[i + k + 7 * width]);
                k += 8 * width;
                ++j;
            }
            ++i;
        }
        return data;
    }

    public static byte[] pixToTscCmd(byte[] src) {
        byte[] data = new byte[src.length / 8];
        int k = 0;
        int j = 0;
        while (k < data.length) {
            byte temp = (byte)(p0[src[j]] + p1[src[j + 1]] + p2[src[j + 2]] + p3[src[j + 3]] + p4[src[j + 4]] + p5[src[j + 5]] + p6[src[j + 6]] + src[j + 7]);
            data[k] = ~temp;
            j += 8;
            ++k;
        }
        return data;
    }

    public static byte[] pixToTscCmd(int x, int y, int mode, byte[] src, int nWidth) {
        int height = src.length / nWidth;
        int width = nWidth / 8;
        String str = "BITMAP " + x + "," + y + "," + width + "," + height + "," + mode + ",";
        byte[] bitmap = null;
        try {
            bitmap = str.getBytes("GB2312");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] arrayOfByte = new byte[src.length / 8];
        int k = 0;
        int j = 0;
        while (k < arrayOfByte.length) {
            byte temp = (byte)(p0[src[j]] + p1[src[j + 1]] + p2[src[j + 2]] + p3[src[j + 3]] + p4[src[j + 4]] + p5[src[j + 5]] + p6[src[j + 6]] + src[j + 7]);
            arrayOfByte[k] = ~temp;
            j += 8;
            ++k;
        }
        byte[] data = new byte[bitmap.length + arrayOfByte.length];
        System.arraycopy(bitmap, 0, data, 0, bitmap.length);
        System.arraycopy(arrayOfByte, 0, data, bitmap.length, arrayOfByte.length);
        return data;
    }

    private static void format_K_dither16x16(int[] orgpixels, int xsize, int ysize, byte[] despixels) {
        int k = 0;
        int y = 0;
        while (y < ysize) {
            int x = 0;
            while (x < xsize) {
                despixels[k] = (orgpixels[k] & 0xFF) > Floyd16x16[x & 0xF][y & 0xF] ? (byte)0 : 1;
                ++k;
                ++x;
            }
            ++y;
        }
    }

    public static byte[] bitmapToBWPix(Bitmap mBitmap) {
        int[] pixels = new int[mBitmap.getWidth() * mBitmap.getHeight()];
        byte[] data = new byte[mBitmap.getWidth() * mBitmap.getHeight()];
        Bitmap grayBitmap = GpUtils.toGrayscale(mBitmap);
        grayBitmap.getPixels(pixels, 0, mBitmap.getWidth(), 0, 0, mBitmap.getWidth(), mBitmap.getHeight());
        GpUtils.format_K_dither16x16(pixels, grayBitmap.getWidth(), grayBitmap.getHeight(), data);
        return data;
    }

    private static void format_K_dither16x16_int(int[] orgpixels, int xsize, int ysize, int[] despixels) {
        int k = 0;
        int y = 0;
        while (y < ysize) {
            int x = 0;
            while (x < xsize) {
                despixels[k] = (orgpixels[k] & 0xFF) > Floyd16x16[x & 0xF][y & 0xF] ? -1 : -16777216;
                ++k;
                ++x;
            }
            ++y;
        }
    }

    private static void format_K_dither8x8_int(int[] orgpixels, int xsize, int ysize, int[] despixels) {
        int k = 0;
        int y = 0;
        while (y < ysize) {
            int x = 0;
            while (x < xsize) {
                despixels[k] = (orgpixels[k] & 0xFF) >> 2 > Floyd8x8[x & 7][y & 7] ? -1 : -16777216;
                ++k;
                ++x;
            }
            ++y;
        }
    }

    public static int[] bitmapToBWPix_int(Bitmap mBitmap, int algorithm) {
        int[] pixels = new int[]{};
        switch (algorithm) {
            case 8: {
                Bitmap grayBitmap = GpUtils.toGrayscale(mBitmap);
                pixels = new int[grayBitmap.getWidth() * grayBitmap.getHeight()];
                grayBitmap.getPixels(pixels, 0, grayBitmap.getWidth(), 0, 0, grayBitmap.getWidth(), grayBitmap.getHeight());
                GpUtils.format_K_dither8x8_int(pixels, grayBitmap.getWidth(), grayBitmap.getHeight(), pixels);
                break;
            }
            case 2: {
                break;
            }
            default: {
                Bitmap grayBitmap = GpUtils.toGrayscale(mBitmap);
                pixels = new int[grayBitmap.getWidth() * grayBitmap.getHeight()];
                grayBitmap.getPixels(pixels, 0, grayBitmap.getWidth(), 0, 0, grayBitmap.getWidth(), grayBitmap.getHeight());
                GpUtils.format_K_dither16x16_int(pixels, grayBitmap.getWidth(), grayBitmap.getHeight(), pixels);
            }
        }
        return pixels;
    }

    public static Bitmap toBinaryImage(Bitmap mBitmap, int nWidth, int algorithm) {
        int width = (nWidth + 7) / 8 * 8;
        int height = mBitmap.getHeight() * width / mBitmap.getWidth();
        Bitmap rszBitmap = GpUtils.resizeImage(mBitmap, width, height);
        int[] pixels = GpUtils.bitmapToBWPix_int(rszBitmap, algorithm);
        rszBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return rszBitmap;
    }
}

