/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.sdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.sdk.b.b;
import com.tencent.mm.sdk.modelmsg.WXMediaMessage;
import java.io.File;

public class WXAppExtendObject
implements WXMediaMessage.IMediaObject {
    private static final String TAG = "MicroMsg.SDK.WXAppExtendObject";
    private static final int EXTINFO_LENGTH_LIMIT = 2048;
    private static final int PATH_LENGTH_LIMIT = 10240;
    private static final int CONTENT_LENGTH_LIMIT = 0xA00000;
    public String extInfo;
    public String filePath;
    public byte[] fileData;

    public WXAppExtendObject() {
    }

    public WXAppExtendObject(String string, byte[] byArray) {
        this.extInfo = string;
        this.fileData = byArray;
    }

    public WXAppExtendObject(String string, String string2) {
        this.extInfo = string;
        this.filePath = string2;
    }

    @Override
    public void serialize(Bundle bundle) {
        bundle.putString("_wxappextendobject_extInfo", this.extInfo);
        bundle.putByteArray("_wxappextendobject_fileData", this.fileData);
        bundle.putString("_wxappextendobject_filePath", this.filePath);
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.extInfo = bundle.getString("_wxappextendobject_extInfo");
        this.fileData = bundle.getByteArray("_wxappextendobject_fileData");
        this.filePath = bundle.getString("_wxappextendobject_filePath");
    }

    @Override
    public int type() {
        return 7;
    }

    @Override
    public boolean checkArgs() {
        if (!(this.extInfo != null && this.extInfo.length() != 0 || this.filePath != null && this.filePath.length() != 0 || this.fileData != null && this.fileData.length != 0)) {
            b.b(TAG, "checkArgs fail, all arguments is null");
            return false;
        }
        if (this.extInfo != null && this.extInfo.length() > 2048) {
            b.b(TAG, "checkArgs fail, extInfo is invalid");
            return false;
        }
        if (this.filePath != null && this.filePath.length() > 10240) {
            b.b(TAG, "checkArgs fail, filePath is invalid");
            return false;
        }
        if (this.filePath != null && this.getFileSize(this.filePath) > 0xA00000) {
            b.b(TAG, "checkArgs fail, fileSize is too large");
            return false;
        }
        if (this.fileData != null && this.fileData.length > 0xA00000) {
            b.b(TAG, "checkArgs fail, fileData is too large");
            return false;
        }
        return true;
    }

    private int getFileSize(String object) {
        if (object == null || ((String)object).length() == 0) {
            return 0;
        }
        if (!((File)(object = new File((String)object))).exists()) {
            return 0;
        }
        return (int)((File)object).length();
    }
}

