/*
 * Decompiled with CFR 0.152.
 */
package com.android.hotpatch.utils;

import android.content.Context;
import android.text.TextUtils;
import com.android.hotpatch.utils.PatchUtils;

public abstract class IPatchManager {
    protected Context context;
    protected String patchConfigUrl;
    protected String patchSavePath;
    protected String patchesInfoImplClass;

    public void patch(final Context context, final String patchConfigUrl, final String patchSavePath, final String patchesInfoImplClass) {
        this.context = context;
        this.patchSavePath = patchSavePath;
        this.patchConfigUrl = patchConfigUrl;
        this.patchesInfoImplClass = patchesInfoImplClass;
        new Thread(new Runnable(){

            @Override
            public void run() {
                String patchUrl = IPatchManager.this.getPatchFileDownloadUrl(patchConfigUrl);
                if (!TextUtils.isEmpty((CharSequence)patchUrl) && IPatchManager.this.isNewPatchFound()) {
                    PatchUtils.saveFile(patchUrl, patchSavePath);
                }
                if (PatchUtils.loadDex(context, patchSavePath, patchesInfoImplClass)) {
                    IPatchManager.this.afterPatchSuccess();
                }
            }
        }).start();
    }

    protected abstract String getPatchFileDownloadUrl(String var1);

    protected abstract boolean isNewPatchFound();

    protected abstract void afterPatchSuccess();
}

