/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.register.mobile;

import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.register.mobile.Country;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CountryList
implements Serializable {
    private static final long serialVersionUID = 1L;
    public List<Country> countries;

    public CountryList(String jsonStr) {
        this.initFromJsonStr(jsonStr);
    }

    private void initFromJsonStr(String jsonStr) {
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.initFromJsonObject(jsonObj);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void initFromJsonObject(JSONObject jsonObj) throws WeiboException {
        try {
            this.countries = new ArrayList<Country>();
            Iterator keys = jsonObj.keys();
            while (keys.hasNext()) {
                String countryName = (String)keys.next();
                JSONObject jsonCountry = jsonObj.optJSONObject(countryName);
                String countryCode = jsonCountry.getString("code");
                JSONObject rule = jsonCountry.optJSONObject("rule");
                JSONArray mcc = rule.optJSONArray("mcc");
                String[] mccArray = new String[mcc.length()];
                int i = 0;
                while (i < mcc.length()) {
                    mccArray[i] = mcc.getString(i);
                    ++i;
                }
                Country country = new Country(countryName, countryCode);
                country.setMccs(mccArray);
                this.countries.add(country);
            }
        }
        catch (JSONException e1) {
            e1.printStackTrace();
            throw new WeiboException(e1);
        }
    }
}

