/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.cmd;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.sina.weibo.sdk.cmd.AppInvokeCmd;
import com.sina.weibo.sdk.cmd.CmdExecutor;
import com.sina.weibo.sdk.utils.SDKNotification;
import java.util.List;

class AppInvokeCmdExecutor
implements CmdExecutor<AppInvokeCmd> {
    private static final int SHOW_NOTICIATION = 1;
    private static final int NOTIFICATION_ID = 2;
    private Context mContext;
    private NotificationHandler mHandler;

    public AppInvokeCmdExecutor(Context ctx) {
        this.mContext = ctx.getApplicationContext();
        this.mHandler = new NotificationHandler(this.mContext.getMainLooper());
    }

    @Override
    public boolean doExecutor(AppInvokeCmd cmd) {
        if (cmd == null || TextUtils.isEmpty((CharSequence)cmd.getNotificationText()) || TextUtils.isEmpty((CharSequence)cmd.getScheme())) {
            return false;
        }
        Message msg = this.mHandler.obtainMessage();
        msg.what = 1;
        msg.obj = cmd;
        this.mHandler.sendMessageDelayed(msg, cmd.getNotificationDelay());
        return true;
    }

    private static void showNotification(Context ctx, AppInvokeCmd cmd) {
        SDKNotification.SDKNotificationBuilder.buildUpon().setNotificationContent(cmd.getNotificationText()).setNotificationPendingIntent(AppInvokeCmdExecutor.buildInvokePendingIntent(ctx, cmd)).setNotificationTitle(cmd.getNotificationTitle()).setTickerText(cmd.getNotificationText()).build(ctx).show(2);
    }

    private static PendingIntent buildInvokePendingIntent(Context ctx, AppInvokeCmd cmd) {
        PackageManager pkg;
        List activities;
        String scheme = cmd.getScheme();
        String url = cmd.getUrl();
        String packageName = cmd.getAppPackage();
        Intent invokeIntent = null;
        Intent intent = AppInvokeCmdExecutor.buildOpenSchemeIntent(scheme, packageName);
        if (intent != null && (activities = (pkg = ctx.getPackageManager()).queryIntentActivities(intent, 65536)) != null && !activities.isEmpty()) {
            invokeIntent = intent;
        }
        if (invokeIntent == null) {
            invokeIntent = AppInvokeCmdExecutor.buildOpenUrlIntent(url);
        }
        if (invokeIntent != null) {
            invokeIntent.setFlags(0x10000000);
            PendingIntent appIntent = PendingIntent.getActivity((Context)ctx, (int)0, (Intent)invokeIntent, (int)0x8000000);
            return appIntent;
        }
        return null;
    }

    private static Intent buildOpenSchemeIntent(String scheme, String packageName) {
        if (!TextUtils.isEmpty((CharSequence)scheme) && Uri.parse((String)scheme).isHierarchical()) {
            Uri uri = Uri.parse((String)scheme);
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            intent.setData(uri);
            intent.setPackage(packageName);
            return intent;
        }
        return null;
    }

    private static Intent buildOpenUrlIntent(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        Uri urlUri = Uri.parse((String)url);
        String urlScheme = urlUri.getScheme();
        if (urlScheme.equalsIgnoreCase("http") || urlScheme.equalsIgnoreCase("https")) {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.VIEW");
            intent.setData(urlUri);
            return intent;
        }
        return null;
    }

    private class NotificationHandler
    extends Handler {
        public NotificationHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 1: {
                    AppInvokeCmdExecutor.showNotification(AppInvokeCmdExecutor.this.mContext, (AppInvokeCmd)msg.obj);
                    break;
                }
            }
        }
    }
}

