/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.auth.sso;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import com.sina.sso.RemoteSSO;
import com.sina.weibo.sdk.WeiboAppManager;
import com.sina.weibo.sdk.auth.AuthInfo;
import com.sina.weibo.sdk.auth.Oauth2AccessToken;
import com.sina.weibo.sdk.auth.WeiboAuthListener;
import com.sina.weibo.sdk.auth.sso.WebAuthHandler;
import com.sina.weibo.sdk.cmd.WbAppActivator;
import com.sina.weibo.sdk.exception.WeiboDialogException;
import com.sina.weibo.sdk.exception.WeiboException;
import com.sina.weibo.sdk.register.mobile.MobileRegisterActivity;
import com.sina.weibo.sdk.utils.AidTask;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.SecurityHelper;
import com.sina.weibo.sdk.utils.Utility;
import java.util.List;

public class SsoHandler {
    private static final String TAG = "Weibo_SSO_login";
    private static final String DEFAULT_WEIBO_REMOTE_SSO_SERVICE_NAME = "com.sina.weibo.remotessoservice";
    private static final int REQUEST_CODE_SSO_AUTH = 32973;
    private WebAuthHandler mWebAuthHandler;
    private WeiboAuthListener mAuthListener;
    private Activity mAuthActivity;
    private int mSSOAuthRequestCode;
    private WeiboAppManager.WeiboInfo mWeiboInfo;
    private AuthInfo mAuthInfo;
    private static final int REQUEST_CODE_MOBILE_REGISTER = 40000;
    public static final String AUTH_FAILED_MSG = "auth failed!!!!!";
    public static final String AUTH_FAILED_NOT_INSTALL_MSG = "not install weibo client!!!!!";
    private ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceDisconnected(ComponentName name) {
            SsoHandler.this.mWebAuthHandler.anthorize(SsoHandler.this.mAuthListener);
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            RemoteSSO remoteSSOservice = RemoteSSO.Stub.asInterface(service);
            try {
                String ssoPackageName = remoteSSOservice.getPackageName();
                String ssoActivityName = remoteSSOservice.getActivityName();
                SsoHandler.this.mAuthActivity.getApplicationContext().unbindService(SsoHandler.this.mConnection);
                if (!SsoHandler.this.startSingleSignOn(ssoPackageName, ssoActivityName)) {
                    SsoHandler.this.mWebAuthHandler.anthorize(SsoHandler.this.mAuthListener);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    };

    public SsoHandler(Activity activity, AuthInfo weiboAuthInfo) {
        this.mAuthActivity = activity;
        this.mAuthInfo = weiboAuthInfo;
        this.mWebAuthHandler = new WebAuthHandler((Context)activity, weiboAuthInfo);
        this.mWeiboInfo = WeiboAppManager.getInstance((Context)activity).getWeiboInfo();
        AidTask.getInstance((Context)this.mAuthActivity).aidTaskInit(weiboAuthInfo.getAppKey());
    }

    public void authorize(WeiboAuthListener listener) {
        this.authorize(32973, listener, AuthType.ALL);
        WbAppActivator.getInstance((Context)this.mAuthActivity, this.mAuthInfo.getAppKey()).activateApp();
    }

    public void authorizeClientSso(WeiboAuthListener listener) {
        this.authorize(32973, listener, AuthType.SsoOnly);
        WbAppActivator.getInstance((Context)this.mAuthActivity, this.mAuthInfo.getAppKey()).activateApp();
    }

    public void authorizeWeb(WeiboAuthListener listener) {
        this.authorize(32973, listener, AuthType.WebOnly);
        WbAppActivator.getInstance((Context)this.mAuthActivity, this.mAuthInfo.getAppKey()).activateApp();
    }

    private void authorize(int requestCode, WeiboAuthListener listener, AuthType authType) {
        this.mSSOAuthRequestCode = requestCode;
        this.mAuthListener = listener;
        boolean onlyClientSso = false;
        if (authType == AuthType.SsoOnly) {
            onlyClientSso = true;
        }
        if (authType == AuthType.WebOnly) {
            if (listener != null) {
                this.mWebAuthHandler.anthorize(listener);
            }
            return;
        }
        boolean bindSucced = this.bindRemoteSSOService(this.mAuthActivity.getApplicationContext());
        if (!bindSucced) {
            if (onlyClientSso) {
                if (this.mAuthListener != null) {
                    this.mAuthListener.onWeiboException(new WeiboException(AUTH_FAILED_NOT_INSTALL_MSG));
                }
            } else {
                this.mWebAuthHandler.anthorize(this.mAuthListener);
            }
        }
    }

    public void authorizeCallBack(int requestCode, int resultCode, Intent data) {
        LogUtil.d(TAG, "requestCode: " + requestCode + ", resultCode: " + resultCode + ", data: " + data);
        if (requestCode == this.mSSOAuthRequestCode) {
            if (resultCode == -1) {
                if (!SecurityHelper.checkResponseAppLegal((Context)this.mAuthActivity, this.mWeiboInfo, data)) {
                    return;
                }
                String error = data.getStringExtra("error");
                if (error == null) {
                    error = data.getStringExtra("error_type");
                }
                if (error != null) {
                    if (error.equals("access_denied") || error.equals("OAuthAccessDeniedException")) {
                        LogUtil.d(TAG, "Login canceled by user.");
                        this.mAuthListener.onCancel();
                    } else {
                        String description = data.getStringExtra("error_description");
                        if (description != null) {
                            error = String.valueOf(error) + ":" + description;
                        }
                        LogUtil.d(TAG, "Login failed: " + error);
                        this.mAuthListener.onWeiboException(new WeiboDialogException(error, resultCode, description));
                    }
                } else {
                    Bundle bundle = data.getExtras();
                    Oauth2AccessToken accessToken = Oauth2AccessToken.parseAccessToken(bundle);
                    if (accessToken != null && accessToken.isSessionValid()) {
                        LogUtil.d(TAG, "Login Success! " + accessToken.toString());
                        this.mAuthListener.onComplete(bundle);
                    } else {
                        LogUtil.d(TAG, "Failed to receive access token by SSO");
                        this.mWebAuthHandler.anthorize(this.mAuthListener);
                    }
                }
            } else if (resultCode == 0) {
                if (data != null) {
                    LogUtil.d(TAG, "Login failed: " + data.getStringExtra("error"));
                    this.mAuthListener.onWeiboException(new WeiboDialogException(data.getStringExtra("error"), data.getIntExtra("error_code", -1), data.getStringExtra("failing_url")));
                } else {
                    LogUtil.d(TAG, "Login canceled by user.");
                    this.mAuthListener.onCancel();
                }
            }
        } else if (requestCode == 40000) {
            if (resultCode == -1) {
                Bundle bundle = data.getExtras();
                Oauth2AccessToken accessToken = Oauth2AccessToken.parseAccessToken(bundle);
                if (accessToken != null && accessToken.isSessionValid()) {
                    LogUtil.d(TAG, "Login Success! " + accessToken.toString());
                    this.mAuthListener.onComplete(bundle);
                }
            } else if (resultCode == 0) {
                if (data != null) {
                    LogUtil.d(TAG, "Login failed: " + data.getStringExtra("error"));
                    String error = data.getStringExtra("error");
                    if (error == null) {
                        error = data.getStringExtra("error_type");
                    }
                    if (error != null) {
                        this.mAuthListener.onWeiboException(new WeiboDialogException(data.getStringExtra("error"), data.getIntExtra("error_code", -1), data.getStringExtra("error_description")));
                    }
                } else {
                    LogUtil.d(TAG, "Login canceled by user.");
                    this.mAuthListener.onCancel();
                }
            }
        }
    }

    public static ComponentName isServiceExisted(Context context, String packageName) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List serviceList = activityManager.getRunningServices(Integer.MAX_VALUE);
        for (ActivityManager.RunningServiceInfo runningServiceInfo : serviceList) {
            ComponentName serviceName = runningServiceInfo.service;
            if (!serviceName.getPackageName().equals(packageName) || !serviceName.getClassName().equals(String.valueOf(packageName) + ".business.RemoteSSOService")) continue;
            return serviceName;
        }
        return null;
    }

    private boolean bindRemoteSSOService(Context context) {
        if (!this.isWeiboAppInstalled()) {
            return false;
        }
        String pkgName = this.mWeiboInfo.getPackageName();
        Intent intent = new Intent(DEFAULT_WEIBO_REMOTE_SSO_SERVICE_NAME);
        intent.setPackage(pkgName);
        return context.bindService(intent, this.mConnection, 1);
    }

    private boolean startSingleSignOn(String ssoPackageName, String ssoActivityName) {
        boolean bSucceed = true;
        Intent intent = new Intent();
        intent.setClassName(ssoPackageName, ssoActivityName);
        intent.putExtras(this.mWebAuthHandler.getAuthInfo().getAuthBundle());
        intent.putExtra("_weibo_command_type", 3);
        intent.putExtra("_weibo_transaction", String.valueOf(System.currentTimeMillis()));
        intent.putExtra("aid", Utility.getAid((Context)this.mAuthActivity, this.mAuthInfo.getAppKey()));
        if (!SecurityHelper.validateAppSignatureForIntent((Context)this.mAuthActivity, intent)) {
            return false;
        }
        String aid = Utility.getAid((Context)this.mAuthActivity, this.mAuthInfo.getAppKey());
        if (!TextUtils.isEmpty((CharSequence)aid)) {
            intent.putExtra("aid", aid);
        }
        try {
            this.mAuthActivity.startActivityForResult(intent, this.mSSOAuthRequestCode);
        }
        catch (ActivityNotFoundException e) {
            bSucceed = false;
        }
        return bSucceed;
    }

    public boolean isWeiboAppInstalled() {
        return this.mWeiboInfo != null && this.mWeiboInfo.isLegal();
    }

    public void registerOrLoginByMobile(String title, WeiboAuthListener listener) {
        this.mAuthListener = listener;
        Intent intentTemp = new Intent((Context)this.mAuthActivity, MobileRegisterActivity.class);
        Bundle param = this.mAuthInfo.getAuthBundle();
        param.putString("register_title", title);
        intentTemp.putExtras(param);
        this.mAuthActivity.startActivityForResult(intentTemp, 40000);
    }

    private static enum AuthType {
        ALL,
        SsoOnly,
        WebOnly;

    }
}

