/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.api;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.sina.weibo.sdk.api.BaseMediaObject;
import com.sina.weibo.sdk.utils.LogUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class VoiceObject
extends BaseMediaObject {
    public static final String EXTRA_KEY_DEFAULTTEXT = "extra_key_defaulttext";
    public String defaultText;
    public String h5Url;
    public String dataUrl;
    public String dataHdUrl;
    public int duration;
    public static final Parcelable.Creator<VoiceObject> CREATOR = new Parcelable.Creator<VoiceObject>(){

        public VoiceObject createFromParcel(Parcel in) {
            return new VoiceObject(in);
        }

        public VoiceObject[] newArray(int size) {
            return new VoiceObject[size];
        }
    };

    public VoiceObject() {
    }

    public VoiceObject(Parcel in) {
        super(in);
        this.h5Url = in.readString();
        this.dataUrl = in.readString();
        this.dataHdUrl = in.readString();
        this.duration = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.h5Url);
        dest.writeString(this.dataUrl);
        dest.writeString(this.dataHdUrl);
        dest.writeInt(this.duration);
    }

    @Override
    public boolean checkArgs() {
        if (!super.checkArgs()) {
            return false;
        }
        if (this.dataUrl != null && this.dataUrl.length() > 512) {
            LogUtil.e("Weibo.VoiceObject", "checkArgs fail, dataUrl is invalid");
            return false;
        }
        if (this.dataHdUrl != null && this.dataHdUrl.length() > 512) {
            LogUtil.e("Weibo.VoiceObject", "checkArgs fail, dataHdUrl is invalid");
            return false;
        }
        if (this.duration <= 0) {
            LogUtil.e("Weibo.VoiceObject", "checkArgs fail, duration is invalid");
            return false;
        }
        return true;
    }

    @Override
    public int getObjType() {
        return 6;
    }

    @Override
    protected BaseMediaObject toExtraMediaObject(String str) {
        if (!TextUtils.isEmpty((CharSequence)str)) {
            try {
                JSONObject json = new JSONObject(str);
                this.defaultText = json.optString(EXTRA_KEY_DEFAULTTEXT);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    protected String toExtraMediaString() {
        try {
            JSONObject json = new JSONObject();
            if (!TextUtils.isEmpty((CharSequence)this.defaultText)) {
                json.put(EXTRA_KEY_DEFAULTTEXT, (Object)this.defaultText);
            }
            return json.toString();
        }
        catch (JSONException jSONException) {
            return "";
        }
    }
}

