/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.call;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.sina.weibo.sdk.call.WeiboNotInstalledException;
import java.util.HashMap;
import java.util.Set;

class CommonUtils {
    CommonUtils() {
    }

    public static String buildUriQuery(HashMap<String, String> paramsMap) {
        StringBuilder queryBuilder = new StringBuilder();
        Set<String> keySet = paramsMap.keySet();
        for (String key : keySet) {
            String value = paramsMap.get(key);
            if (value == null) continue;
            queryBuilder.append("&").append(key).append("=").append(value);
        }
        String query = queryBuilder.toString();
        return query.replaceFirst("&", "?");
    }

    public static void openWeiboActivity(Context context, String action, String uri, String packageName) throws WeiboNotInstalledException {
        try {
            if (packageName != null) {
                Intent intent = new Intent();
                intent.setAction(action);
                intent.setData(Uri.parse((String)uri));
                intent.setPackage(packageName);
                context.startActivity(intent);
            } else {
                Intent intent = new Intent();
                intent.setAction(action);
                intent.setData(Uri.parse((String)uri));
                context.startActivity(intent);
            }
        }
        catch (ActivityNotFoundException exception) {
            if (packageName != null) {
                try {
                    Intent intent = new Intent();
                    intent.setAction(action);
                    intent.setData(Uri.parse((String)uri));
                    context.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    throw new WeiboNotInstalledException("\u65e0\u6cd5\u627e\u5230\u5fae\u535a\u5b98\u65b9\u5ba2\u6237\u7aef");
                }
            }
            throw new WeiboNotInstalledException("\u65e0\u6cd5\u627e\u5230\u5fae\u535a\u5b98\u65b9\u5ba2\u6237\u7aef");
        }
    }

    public static void openWeiboActivity(Context context, String action, String uri) throws WeiboNotInstalledException {
        try {
            Intent intent = new Intent();
            intent.setAction(action);
            intent.setData(Uri.parse((String)uri));
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException exception) {
            throw new WeiboNotInstalledException("\u65e0\u6cd5\u627e\u5230\u5fae\u535a\u5b98\u65b9\u5ba2\u6237\u7aef");
        }
    }
}

