/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.net.utils;

import com.umeng.socialize.net.utils.AesHelper;
import com.umeng.socialize.net.utils.BaseNCodec;

public class Base64
extends BaseNCodec {
    private static final int BITS_PER_ENCODED_BYTE = 6;
    private static final int BYTES_PER_UNENCODED_BLOCK = 3;
    private static final int BYTES_PER_ENCODED_BLOCK = 4;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final int MASK_6BITS = 63;
    private final byte[] mEncodeTable;
    private final byte[] mDecodeTable = DECODE_TABLE;
    private final byte[] mLineSeparator;
    private final int mDecodeSize;
    private final int mEncodeSize;
    private int mBitWorkArea;

    public Base64() {
        this(0);
    }

    public Base64(boolean bl) {
        this(76, CHUNK_SEPARATOR, bl);
    }

    public Base64(int n) {
        this(n, CHUNK_SEPARATOR);
    }

    public Base64(int n, byte[] byArray) {
        this(n, byArray, false);
    }

    public Base64(int n, byte[] byArray, boolean bl) {
        super(3, 4, n, byArray == null ? 0 : byArray.length);
        if (byArray != null) {
            if (this.containsAlphabetOrPad(byArray)) {
                String string = AesHelper.newStringUtf8(byArray);
                throw new IllegalArgumentException("lineSeparator must not contain base64 characters: [" + string + "]");
            }
            if (n > 0) {
                this.mEncodeSize = 4 + byArray.length;
                this.mLineSeparator = new byte[byArray.length];
                System.arraycopy(byArray, 0, this.mLineSeparator, 0, byArray.length);
            } else {
                this.mEncodeSize = 4;
                this.mLineSeparator = null;
            }
        } else {
            this.mEncodeSize = 4;
            this.mLineSeparator = null;
        }
        this.mDecodeSize = this.mEncodeSize - 1;
        this.mEncodeTable = bl ? URL_SAFE_ENCODE_TABLE : STANDARD_ENCODE_TABLE;
    }

    @Override
    void encode(byte[] byArray, int n, int n2) {
        if (this.mEof) {
            return;
        }
        if (n2 < 0) {
            this.mEof = true;
            if (0 == this.mModulus && this.mLineLength == 0) {
                return;
            }
            this.ensureBufferSize(this.mEncodeSize);
            int n3 = this.mPos;
            switch (this.mModulus) {
                case 1: {
                    this.mBuffer[this.mPos++] = this.mEncodeTable[this.mBitWorkArea >> 2 & 0x3F];
                    this.mBuffer[this.mPos++] = this.mEncodeTable[this.mBitWorkArea << 4 & 0x3F];
                    if (this.mEncodeTable != STANDARD_ENCODE_TABLE) break;
                    this.mBuffer[this.mPos++] = 61;
                    this.mBuffer[this.mPos++] = 61;
                    break;
                }
                case 2: {
                    this.mBuffer[this.mPos++] = this.mEncodeTable[this.mBitWorkArea >> 10 & 0x3F];
                    this.mBuffer[this.mPos++] = this.mEncodeTable[this.mBitWorkArea >> 4 & 0x3F];
                    this.mBuffer[this.mPos++] = this.mEncodeTable[this.mBitWorkArea << 2 & 0x3F];
                    if (this.mEncodeTable != STANDARD_ENCODE_TABLE) break;
                    this.mBuffer[this.mPos++] = 61;
                }
            }
            this.mCurrentLinePos += this.mPos - n3;
            if (this.mLineLength > 0 && this.mCurrentLinePos > 0) {
                System.arraycopy(this.mLineSeparator, 0, this.mBuffer, this.mPos, this.mLineSeparator.length);
                this.mPos += this.mLineSeparator.length;
            }
        } else {
            for (int j = 0; j < n2; ++j) {
                this.ensureBufferSize(this.mEncodeSize);
                this.mModulus = (this.mModulus + 1) % 3;
                int n4 = byArray[n++];
                if (n4 < 0) {
                    n4 += 256;
                }
                this.mBitWorkArea = (this.mBitWorkArea << 8) + n4;
                if (0 != this.mModulus) continue;
                this.mBuffer[this.mPos++] = this.mEncodeTable[this.mBitWorkArea >> 18 & 0x3F];
                this.mBuffer[this.mPos++] = this.mEncodeTable[this.mBitWorkArea >> 12 & 0x3F];
                this.mBuffer[this.mPos++] = this.mEncodeTable[this.mBitWorkArea >> 6 & 0x3F];
                this.mBuffer[this.mPos++] = this.mEncodeTable[this.mBitWorkArea & 0x3F];
                this.mCurrentLinePos += 4;
                if (this.mLineLength <= 0 || this.mLineLength > this.mCurrentLinePos) continue;
                System.arraycopy(this.mLineSeparator, 0, this.mBuffer, this.mPos, this.mLineSeparator.length);
                this.mPos += this.mLineSeparator.length;
                this.mCurrentLinePos = 0;
            }
        }
    }

    @Override
    void decode(byte[] byArray, int n, int n2) {
        if (this.mEof) {
            return;
        }
        if (n2 < 0) {
            this.mEof = true;
        }
        for (int j = 0; j < n2; ++j) {
            byte by;
            this.ensureBufferSize(this.mDecodeSize);
            byte by2 = byArray[n++];
            if (by2 == 61) {
                this.mEof = true;
                break;
            }
            if (by2 < 0 || by2 >= DECODE_TABLE.length || (by = DECODE_TABLE[by2]) < 0) continue;
            this.mModulus = (this.mModulus + 1) % 4;
            this.mBitWorkArea = (this.mBitWorkArea << 6) + by;
            if (this.mModulus != 0) continue;
            this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 16 & 0xFF);
            this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 8 & 0xFF);
            this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea & 0xFF);
        }
        if (this.mEof && this.mModulus != 0) {
            this.ensureBufferSize(this.mDecodeSize);
            switch (this.mModulus) {
                case 2: {
                    this.mBitWorkArea >>= 4;
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea & 0xFF);
                    break;
                }
                case 3: {
                    this.mBitWorkArea >>= 2;
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea >> 8 & 0xFF);
                    this.mBuffer[this.mPos++] = (byte)(this.mBitWorkArea & 0xFF);
                }
            }
        }
    }

    public static String encodeBase64String(byte[] byArray) {
        return AesHelper.newStringUtf8(Base64.encodeBase64(byArray, false));
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl) {
        return Base64.encodeBase64(byArray, bl, false);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl, boolean bl2) {
        return Base64.encodeBase64(byArray, bl, bl2, Integer.MAX_VALUE);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl, boolean bl2, int n) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        Base64 base64 = bl ? new Base64(bl2) : new Base64(0, CHUNK_SEPARATOR, bl2);
        long l = base64.getEncodedLength(byArray);
        if (l > (long)n) {
            throw new IllegalArgumentException("Input array too big, the output array would be bigger (" + l + ") than the specified maximum size of " + n);
        }
        return base64.encode(byArray);
    }

    public static byte[] decodeBase64(String string) {
        return new Base64().decode(string);
    }

    @Override
    protected boolean isInAlphabet(byte by) {
        return by >= 0 && by < this.mDecodeTable.length && this.mDecodeTable[by] != -1;
    }
}

