/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.register.mobile;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import com.sina.weibo.sdk.component.view.TitleBar;
import com.sina.weibo.sdk.register.mobile.Country;
import com.sina.weibo.sdk.register.mobile.CountryList;
import com.sina.weibo.sdk.register.mobile.LetterIndexBar;
import com.sina.weibo.sdk.register.mobile.PinyinUtils;
import com.sina.weibo.sdk.register.mobile.SelectCountryItemView;
import com.sina.weibo.sdk.register.mobile.SelectCountryTitleView;
import com.sina.weibo.sdk.utils.ResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SelectCountryActivity
extends Activity
implements LetterIndexBar.OnIndexChangeListener {
    public static final String EXTRA_COUNTRY_CODE = "code";
    public static final String EXTRA_COUNTRY_NAME = "name";
    private static final String SELECT_COUNTRY_EN = "Region";
    private static final String SELECT_COUNTRY_ZH_CN = "\u9009\u62e9\u56fd\u5bb6";
    private static final String SELECT_COUNTRY_ZH_TW = "\u9078\u64c7\u570b\u5bb6";
    private static final String CHINA_EN = "China";
    private static final String CHINA_CN = "\u4e2d\u56fd";
    private static final String CHINA_TW = "\u4e2d\u570b";
    private static final String INFO_EN = "Common";
    private static final String INFO_CN = "\u5e38\u7528";
    private static final String INFO_TW = "\u5e38\u7528";
    private LetterIndexBar mLetterIndexBar;
    private List<Country>[] arrSubCountry;
    private List<Country> mCountries;
    String countryStr = "";
    private CountryList result;
    private List<IndexCountry> indexCountries = new ArrayList<IndexCountry>();
    private ListView mListView;
    private CountryAdapter mAdapter;
    private RelativeLayout mMainLayout;
    private FrameLayout mFrameLayout;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initView();
    }

    private void initView() {
        this.mMainLayout = new RelativeLayout((Context)this);
        RelativeLayout.LayoutParams mMainLayoutLp = new RelativeLayout.LayoutParams(-1, -1);
        this.mMainLayout.setLayoutParams((ViewGroup.LayoutParams)mMainLayoutLp);
        TitleBar titleBar = new TitleBar((Context)this);
        titleBar.setId(1);
        titleBar.setLeftBtnBg((Drawable)ResourceManager.createStateListDrawable((Context)this, "weibosdk_navigationbar_back.png", "weibosdk_navigationbar_back_highlighted.png"));
        titleBar.setTitleBarText(ResourceManager.getString((Context)this, SELECT_COUNTRY_EN, SELECT_COUNTRY_ZH_CN, SELECT_COUNTRY_ZH_TW));
        titleBar.setTitleBarClickListener(new TitleBar.ListenerOnTitleBtnClicked(){

            @Override
            public void onLeftBtnClicked() {
                SelectCountryActivity.this.setResult(0);
                SelectCountryActivity.this.finish();
            }
        });
        this.mMainLayout.addView((View)titleBar);
        this.mFrameLayout = new FrameLayout((Context)this);
        RelativeLayout.LayoutParams mFrameLp = new RelativeLayout.LayoutParams(-1, -1);
        mFrameLp.addRule(3, titleBar.getId());
        this.mFrameLayout.setLayoutParams((ViewGroup.LayoutParams)mFrameLp);
        this.mMainLayout.addView((View)this.mFrameLayout);
        this.mListView = new ListView((Context)this);
        AbsListView.LayoutParams mListViewLp = new AbsListView.LayoutParams(-1, -1);
        this.mListView.setLayoutParams((ViewGroup.LayoutParams)mListViewLp);
        this.mListView.setFadingEdgeLength(0);
        this.mListView.setSelector((Drawable)new ColorDrawable(0));
        this.mListView.setDividerHeight(ResourceManager.dp2px((Context)this, 1));
        this.mListView.setCacheColorHint(0);
        this.mListView.setDrawSelectorOnTop(false);
        this.mListView.setScrollingCacheEnabled(false);
        this.mListView.setScrollbarFadingEnabled(false);
        this.mListView.setVerticalScrollBarEnabled(false);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                Country country = (Country)SelectCountryActivity.this.mAdapter.getItem(position);
                if (country == null) {
                    return;
                }
                Intent intent = new Intent();
                intent.putExtra(SelectCountryActivity.EXTRA_COUNTRY_CODE, country.getCode());
                intent.putExtra(SelectCountryActivity.EXTRA_COUNTRY_NAME, country.getName());
                SelectCountryActivity.this.setResult(-1, intent);
                SelectCountryActivity.this.finish();
            }
        });
        this.mFrameLayout.addView((View)this.mListView);
        this.mAdapter = new CountryAdapter();
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mLetterIndexBar = new LetterIndexBar((Context)this);
        this.mLetterIndexBar.setIndexChangeListener(this);
        FrameLayout.LayoutParams mLetterIndexBarLp = new FrameLayout.LayoutParams(-2, -1);
        mLetterIndexBarLp.gravity = 5;
        this.mLetterIndexBar.setLayoutParams((ViewGroup.LayoutParams)mLetterIndexBarLp);
        this.mFrameLayout.addView((View)this.mLetterIndexBar);
        PinyinUtils.getInstance((Context)this);
        Locale locale = ResourceManager.getLanguage();
        this.countryStr = Locale.SIMPLIFIED_CHINESE.equals(locale) ? ResourceManager.readCountryFromAsset((Context)this, "countryCode.txt") : (Locale.TRADITIONAL_CHINESE.equals(locale) ? ResourceManager.readCountryFromAsset((Context)this, "countryCodeTw.txt") : ResourceManager.readCountryFromAsset((Context)this, "countryCodeEn.txt"));
        this.result = new CountryList(this.countryStr);
        this.mCountries = this.result.countries;
        this.arrSubCountry = this.subCountries(this.mCountries);
        this.indexCountries = this.compose(this.arrSubCountry);
        this.mAdapter.notifyDataSetChanged();
        this.setContentView((View)this.mMainLayout);
    }

    protected void onPause() {
        super.onPause();
    }

    @Override
    public void onIndexChange(int index) {
        if (this.arrSubCountry != null && index < this.arrSubCountry.length && this.arrSubCountry[index] != null) {
            this.mListView.setSelection(this.indexCountries.indexOf(new IndexCountry(index, -1)));
        }
    }

    private List<Country>[] subCountries(List<Country> countries) {
        ArrayList[] arr = new ArrayList[27];
        Country commonCountry = new Country();
        commonCountry.setCode("0086");
        commonCountry.setName(ResourceManager.getString((Context)this, CHINA_EN, CHINA_CN, CHINA_TW));
        arr[0] = new ArrayList();
        arr[0].add(commonCountry);
        int i = 0;
        while (i < countries.size()) {
            Country country = countries.get(i);
            if (country.getCode().equals("00852") || country.getCode().equals("00853") || country.getCode().equals("00886")) {
                arr[0].add(country);
            } else {
                int index = country.getPinyin().charAt(0) - 97 + 1;
                if (arr[index] == null) {
                    arr[index] = new ArrayList();
                }
                arr[index].add(country);
            }
            ++i;
        }
        return arr;
    }

    private List<IndexCountry> compose(List<Country>[] arrSubCountry) {
        ArrayList<IndexCountry> indexFollows = new ArrayList<IndexCountry>();
        if (arrSubCountry != null) {
            int i = 0;
            while (i < arrSubCountry.length) {
                List<Country> list = arrSubCountry[i];
                if (list != null && list.size() > 0) {
                    int j = 0;
                    while (j < list.size()) {
                        if (j == 0) {
                            indexFollows.add(new IndexCountry(i, -1));
                        }
                        indexFollows.add(new IndexCountry(i, j));
                        ++j;
                    }
                }
                ++i;
            }
        }
        return indexFollows;
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    private class CountryAdapter
    extends BaseAdapter {
        private CountryAdapter() {
        }

        public int getCount() {
            if (SelectCountryActivity.this.indexCountries != null) {
                return SelectCountryActivity.this.indexCountries.size();
            }
            return 0;
        }

        public Object getItem(int position) {
            if (SelectCountryActivity.this.indexCountries == null || SelectCountryActivity.this.indexCountries.isEmpty()) {
                return null;
            }
            if (position == SelectCountryActivity.this.indexCountries.size()) {
                return null;
            }
            IndexCountry indexCountry = (IndexCountry)SelectCountryActivity.this.indexCountries.get(position);
            if (indexCountry.indexInList == -1) {
                return null;
            }
            return SelectCountryActivity.this.arrSubCountry[indexCountry.indexInListArray].get(indexCountry.indexInList);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            RelativeLayout view = null;
            IndexCountry indexCountry = (IndexCountry)SelectCountryActivity.this.indexCountries.get(position);
            if (convertView == null) {
                if (indexCountry.indexInList == -1) {
                    view = this.createTitleView(indexCountry.indexInListArray);
                } else {
                    Country coutry = (Country)SelectCountryActivity.this.arrSubCountry[indexCountry.indexInListArray].get(indexCountry.indexInList);
                    view = new SelectCountryItemView((Context)SelectCountryActivity.this, coutry.getName(), coutry.getCode());
                }
            } else {
                if (indexCountry.indexInList == -1) {
                    if (convertView instanceof SelectCountryTitleView) {
                        if (indexCountry.indexInListArray == 0) {
                            ((SelectCountryTitleView)((Object)convertView)).update(ResourceManager.getString((Context)SelectCountryActivity.this, SelectCountryActivity.INFO_EN, "\u5e38\u7528", "\u5e38\u7528"));
                        } else {
                            convertView = this.createTitleView(indexCountry.indexInListArray);
                        }
                    } else {
                        convertView = this.createTitleView(indexCountry.indexInListArray);
                    }
                } else {
                    Country coutry = (Country)SelectCountryActivity.this.arrSubCountry[indexCountry.indexInListArray].get(indexCountry.indexInList);
                    if (convertView instanceof SelectCountryTitleView) {
                        convertView = new SelectCountryItemView((Context)SelectCountryActivity.this, coutry.getName(), coutry.getCode());
                    } else {
                        ((SelectCountryItemView)((Object)convertView)).updateContent(coutry.getName(), coutry.getCode());
                    }
                }
                view = convertView;
            }
            return view;
        }

        private SelectCountryTitleView createTitleView(int indexInListArray) {
            SelectCountryTitleView titleView = new SelectCountryTitleView(SelectCountryActivity.this.getApplicationContext());
            if (indexInListArray == 0) {
                titleView.setTitle(ResourceManager.getString((Context)SelectCountryActivity.this, SelectCountryActivity.INFO_EN, "\u5e38\u7528", "\u5e38\u7528"));
            } else {
                titleView.setTitle(String.valueOf((char)(indexInListArray + 65 - 1)));
            }
            return titleView;
        }
    }

    private class IndexCountry {
        int indexInListArray;
        int indexInList;

        IndexCountry(int indexInListArray, int indexInList) {
            this.indexInListArray = indexInListArray;
            this.indexInList = indexInList;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IndexCountry)) {
                return false;
            }
            if (this.indexInList != -1) {
                return false;
            }
            IndexCountry another = (IndexCountry)o;
            return this.indexInListArray == another.indexInListArray && this.indexInList == another.indexInList;
        }
    }
}

