/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.net;

import android.text.TextUtils;
import com.umeng.socialize.bean.UMFriend;
import com.umeng.socialize.net.base.SocializeReseponse;
import com.umeng.socialize.utils.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class ShareFriendsResponse
extends SocializeReseponse {
    public List<UMFriend> mFriends;

    public ShareFriendsResponse(JSONObject jSONObject) {
        super(jSONObject);
    }

    @Override
    public void parseJsonObject() {
        JSONObject jSONObject = this.mJsonData;
        if (jSONObject == null) {
            Log.e("SocializeReseponse", "data json is null....");
        } else {
            this.mFriends = new ArrayList<UMFriend>();
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                try {
                    String string = iterator.next().toString();
                    JSONObject jSONObject2 = (JSONObject)this.mJsonData.get(string);
                    if (!jSONObject2.has("name")) continue;
                    String string2 = jSONObject2.getString("name");
                    if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) continue;
                    UMFriend uMFriend = new UMFriend();
                    uMFriend.setFid(string);
                    uMFriend.setName(string2);
                    String string3 = jSONObject2.optString("link_name", "");
                    uMFriend.setLinkName(TextUtils.isEmpty((CharSequence)string3) ? string2 : string3);
                    String string4 = jSONObject2.optString("pinyin", "");
                    if (!TextUtils.isEmpty((CharSequence)string4)) {
                        UMFriend.PinYin pinYin = new UMFriend.PinYin();
                        pinYin.mInitial = String.valueOf(ShareFriendsResponse.reverse(string4.charAt(0)));
                        pinYin.mTotalPinyin = string4;
                        uMFriend.setPinyin(pinYin);
                    }
                    if (jSONObject2.has("profile_image_url")) {
                        uMFriend.setIcon(jSONObject2.getString("profile_image_url"));
                    }
                    this.mFriends.add(uMFriend);
                }
                catch (Exception exception) {
                    Log.e("SocializeReseponse", "Parse friend data error", exception);
                }
            }
        }
    }

    public static char reverse(char c2) {
        if (c2 >= 'a' && c2 <= 'z') {
            return (char)(c2 - 32);
        }
        return c2;
    }
}

