/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk.net;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLSocketFactory;

public class SSLSocketFactoryEx
extends SSLSocketFactory {
    private static final String TAG = SSLSocketFactoryEx.class.getName();
    SSLContext sslContext = SSLContext.getInstance("TLS");

    public SSLSocketFactoryEx(KeyStore truststore) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        super(truststore);
        this.sslContext.init(null, new TrustManager[]{new KeyStoresTrustManagerEX(truststore)}, null);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public Socket createSocket() throws IOException {
        return this.sslContext.getSocketFactory().createSocket();
    }

    public static class KeyStoresTrustManagerEX
    implements X509TrustManager {
        protected ArrayList<X509TrustManager> x509TrustManagers = new ArrayList();

        protected KeyStoresTrustManagerEX(KeyStore ... additionalkeyStores) {
            int n;
            ArrayList<TrustManagerFactory> factories = new ArrayList<TrustManagerFactory>();
            try {
                TrustManagerFactory original = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                original.init((KeyStore)null);
                factories.add(original);
                KeyStore[] keyStoreArray = additionalkeyStores;
                n = additionalkeyStores.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyStore keyStore = keyStoreArray[n2];
                    TrustManagerFactory additionalCerts = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    additionalCerts.init(keyStore);
                    factories.add(additionalCerts);
                    ++n2;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (TrustManagerFactory tmf : factories) {
                TrustManager[] trustManagerArray = tmf.getTrustManagers();
                int n3 = trustManagerArray.length;
                n = 0;
                while (n < n3) {
                    TrustManager tm = trustManagerArray[n];
                    if (tm instanceof X509TrustManager) {
                        this.x509TrustManagers.add((X509TrustManager)tm);
                    }
                    ++n;
                }
            }
            if (this.x509TrustManagers.size() == 0) {
                throw new RuntimeException("Couldn't find any X509TrustManagers");
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            X509TrustManager defaultX509TrustManager = this.x509TrustManagers.get(0);
            defaultX509TrustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509TrustManager tm : this.x509TrustManagers) {
                try {
                    tm.checkServerTrusted(chain, authType);
                    return;
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
            throw new CertificateException();
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
            for (X509TrustManager tm : this.x509TrustManagers) {
                list.addAll(Arrays.asList(tm.getAcceptedIssuers()));
            }
            return list.toArray(new X509Certificate[list.size()]);
        }
    }
}

