/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tauth;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import com.tencent.connect.auth.QQAuth;
import com.tencent.connect.auth.QQToken;
import com.tencent.connect.avatar.QQAvatar;
import com.tencent.connect.common.UIListenerManager;
import com.tencent.connect.share.QQShare;
import com.tencent.connect.share.QzonePublish;
import com.tencent.connect.share.QzoneShare;
import com.tencent.open.GameAppOperation;
import com.tencent.open.LocationApi;
import com.tencent.open.SocialApi;
import com.tencent.open.TaskGuide;
import com.tencent.open.a.f;
import com.tencent.open.b.d;
import com.tencent.open.utils.Global;
import com.tencent.open.utils.HttpUtils;
import com.tencent.open.utils.SystemUtils;
import com.tencent.open.wpa.WPA;
import com.tencent.open.yyb.AppbarAgent;
import com.tencent.tauth.IRequestListener;
import com.tencent.tauth.IUiListener;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class Tencent {
    private static final String TAG = "openSDK_LOG.Tencent";
    public static final int REQUEST_LOGIN = 10001;
    private final QQAuth mQQAuth;
    private static Tencent sInstance;
    private LocationApi mLocationApi;
    private AppbarAgent mAgent;

    private Tencent(String string, Context context) {
        Global.setContext(context.getApplicationContext());
        this.mQQAuth = QQAuth.createInstance(string, context);
    }

    public static synchronized Tencent createInstance(String string, Context context) {
        Global.setContext(context.getApplicationContext());
        f.c(TAG, "createInstance()  -- start");
        if (sInstance == null) {
            sInstance = new Tencent(string, context);
        } else if (!string.equals(sInstance.getAppId())) {
            sInstance.logout(context);
            sInstance = new Tencent(string, context);
        }
        if (!Tencent.checkManifestConfig(context, string)) {
            return null;
        }
        f.c(TAG, "createInstance()  -- end");
        return sInstance;
    }

    private static boolean checkManifestConfig(Context context, String string) {
        Object object;
        ComponentName componentName;
        try {
            componentName = new ComponentName(context.getPackageName(), "com.tencent.tauth.AuthActivity");
            object = context.getPackageManager();
            object.getActivityInfo(componentName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string2 = "\u6ca1\u6709\u5728AndroidManifest.xml\u4e2d\u68c0\u6d4b\u5230com.tencent.tauth.AuthActivity,\u8bf7\u52a0\u4e0acom.tencent.tauth.AuthActivity,\u5e76\u914d\u7f6e<data android:scheme=\"tencent" + string + "\" />,\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u5b98\u7f51\u6587\u6863.";
            string2 = string2 + "\n\u914d\u7f6e\u793a\u4f8b\u5982\u4e0b: \n<activity\n     android:name=\"com.tencent.tauth.AuthActivity\"\n     android:noHistory=\"true\"\n     android:launchMode=\"singleTask\">\n<intent-filter>\n    <action android:name=\"android.intent.action.VIEW\" />\n    <category android:name=\"android.intent.category.DEFAULT\" />\n    <category android:name=\"android.intent.category.BROWSABLE\" />\n    <data android:scheme=\"tencent" + string + "\" />\n" + "</intent-filter>\n" + "</activity>";
            f.e(TAG, "AndroidManifest.xml \u6ca1\u6709\u68c0\u6d4b\u5230com.tencent.tauth.AuthActivity" + string2);
            return false;
        }
        try {
            componentName = new ComponentName(context.getPackageName(), "com.tencent.connect.common.AssistActivity");
            object = context.getPackageManager();
            object.getActivityInfo(componentName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = "\u6ca1\u6709\u5728AndroidManifest.xml\u4e2d\u68c0\u6d4b\u5230com.tencent.connect.common.AssistActivity,\u8bf7\u52a0\u4e0acom.tencent.connect.common.AssistActivity,\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u5b98\u7f51\u6587\u6863.";
            object = (String)object + "\n\u914d\u7f6e\u793a\u4f8b\u5982\u4e0b: \n<activity\n     android:name=\"com.tencent.connect.common.AssistActivity\"\n     android:screenOrientation=\"behind\"\n     android:theme=\"@android:style/Theme.Translucent.NoTitleBar\"\n     android:configChanges=\"orientation|keyboardHidden\">\n</activity>";
            f.e(TAG, "AndroidManifest.xml \u6ca1\u6709\u68c0\u6d4b\u5230com.tencent.connect.common.AssistActivity\n" + (String)object);
            return false;
        }
        return true;
    }

    public int login(Activity activity, String string, IUiListener iUiListener) {
        f.c(TAG, "login() with activity, scope is " + string);
        return this.mQQAuth.login(activity, string, iUiListener);
    }

    public int login(Fragment fragment, String string, IUiListener iUiListener) {
        f.c(TAG, "login() with fragment, scope is " + string);
        return this.mQQAuth.login(fragment, string, iUiListener, "");
    }

    public int loginServerSide(Activity activity, String string, IUiListener iUiListener) {
        f.c(TAG, "loginServerSide() with activity, scope = " + string + ",server_side");
        return this.mQQAuth.login(activity, string + ",server_side", iUiListener);
    }

    public int loginServerSide(Fragment fragment, String string, IUiListener iUiListener) {
        f.c(TAG, "loginServerSide() with fragment, scope = " + string + ",server_side");
        return this.mQQAuth.login(fragment, string + ",server_side", iUiListener, "");
    }

    public int loginWithOEM(Activity activity, String string, IUiListener iUiListener, String string2, String string3, String string4) {
        f.c(TAG, "loginWithOEM() with activity, scope = " + string);
        return this.mQQAuth.loginWithOEM(activity, string, iUiListener, string2, string3, string4);
    }

    public void logout(Context context) {
        f.c(TAG, "logout()");
        this.mQQAuth.getQQToken().setAccessToken(null, "0");
        this.mQQAuth.getQQToken().setOpenId(null);
    }

    public int reAuth(Activity activity, String string, IUiListener iUiListener) {
        f.c(TAG, "reAuth() with activity, scope = " + string);
        return this.mQQAuth.reAuth(activity, string, iUiListener);
    }

    public void reportDAU() {
        this.mQQAuth.reportDAU();
    }

    public void checkLogin(IUiListener iUiListener) {
        f.c(TAG, "checkLogin()");
        this.mQQAuth.checkLogin(iUiListener);
    }

    public int invite(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "invite()");
        SocialApi socialApi = new SocialApi(this.mQQAuth.getQQToken());
        socialApi.invite(activity, bundle, iUiListener);
        return 0;
    }

    public int story(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "story()");
        SocialApi socialApi = new SocialApi(this.mQQAuth.getQQToken());
        socialApi.story(activity, bundle, iUiListener);
        return 0;
    }

    public int gift(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "gift()");
        SocialApi socialApi = new SocialApi(this.mQQAuth.getQQToken());
        socialApi.gift(activity, bundle, iUiListener);
        return 0;
    }

    public int ask(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "ask()");
        SocialApi socialApi = new SocialApi(this.mQQAuth.getQQToken());
        socialApi.ask(activity, bundle, iUiListener);
        return 0;
    }

    public void requestAsync(String string, Bundle bundle, String string2, IRequestListener iRequestListener, Object object) {
        f.c(TAG, "requestAsync()");
        HttpUtils.requestAsync(this.mQQAuth.getQQToken(), Global.getContext(), string, bundle, string2, iRequestListener);
    }

    public JSONObject request(String string, Bundle bundle, String string2) throws IOException, JSONException, HttpUtils.NetworkUnavailableException, HttpUtils.HttpStatusException {
        f.c(TAG, "request()");
        return HttpUtils.request(this.mQQAuth.getQQToken(), Global.getContext(), string, bundle, string2);
    }

    public void shareToQQ(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "shareToQQ()");
        QQShare qQShare = new QQShare((Context)activity, this.mQQAuth.getQQToken());
        qQShare.shareToQQ(activity, bundle, iUiListener);
    }

    public void shareToQzone(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "shareToQzone()");
        QzoneShare qzoneShare = new QzoneShare((Context)activity, this.mQQAuth.getQQToken());
        qzoneShare.shareToQzone(activity, bundle, iUiListener);
    }

    public void publishToQzone(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "publishToQzone()");
        QzonePublish qzonePublish = new QzonePublish((Context)activity, this.mQQAuth.getQQToken());
        qzonePublish.publishToQzone(activity, bundle, iUiListener);
    }

    public void releaseResource() {
    }

    public boolean onActivityResult(int n2, int n3, Intent intent) {
        f.c(TAG, "onActivityResult() deprecated, will do nothing");
        return false;
    }

    public static boolean onActivityResultData(int n2, int n3, Intent intent, IUiListener iUiListener) {
        f.c(TAG, "onActivityResultData() reqcode = " + n2 + ", resultcode = " + n3 + ", data = null ? " + (intent == null) + ", listener = null ? " + (iUiListener == null));
        return UIListenerManager.getInstance().onActivityResult(n2, n3, intent, iUiListener);
    }

    public boolean isSessionValid() {
        return this.mQQAuth.isSessionValid();
    }

    public String getAppId() {
        return this.mQQAuth.getQQToken().getAppId();
    }

    public String getAccessToken() {
        return this.mQQAuth.getQQToken().getAccessToken();
    }

    public long getExpiresIn() {
        return this.mQQAuth.getQQToken().getExpireTimeInSecond();
    }

    public String getOpenId() {
        return this.mQQAuth.getQQToken().getOpenId();
    }

    @Deprecated
    public void handleLoginData(Intent intent, IUiListener iUiListener) {
        f.c(TAG, "handleLoginData() data = null ? " + (intent == null) + ", listener = null ? " + (iUiListener == null));
        UIListenerManager.getInstance().handleDataToListener(intent, iUiListener);
    }

    public static void handleResultData(Intent intent, IUiListener iUiListener) {
        f.c(TAG, "handleResultData() data = null ? " + (intent == null) + ", listener = null ? " + (iUiListener == null));
        UIListenerManager.getInstance().handleDataToListener(intent, iUiListener);
    }

    public void setAccessToken(String string, String string2) {
        f.a(TAG, "setAccessToken(), expiresIn = " + string2 + "");
        this.mQQAuth.setAccessToken(string, string2);
    }

    public void setOpenId(String string) {
        f.a(TAG, "setOpenId() --start");
        this.mQQAuth.setOpenId(Global.getContext(), string);
        f.a(TAG, "setOpenId() --end");
    }

    public boolean isReady() {
        boolean bl = this.isSessionValid() && this.getOpenId() != null;
        return bl;
    }

    public QQToken getQQToken() {
        return this.mQQAuth.getQQToken();
    }

    public boolean isSupportSSOLogin(Activity activity) {
        String string = SystemUtils.getAppVersionName((Context)activity, "com.tencent.mobileqq");
        if (string == null) {
            return false;
        }
        return SystemUtils.checkMobileQQ((Context)activity);
    }

    public void makeFriend(Activity activity, Bundle bundle) {
        GameAppOperation gameAppOperation = new GameAppOperation(this.getQQToken());
        gameAppOperation.makeFriend(activity, bundle);
    }

    public void bindQQGroup(Activity activity, Bundle bundle) {
        GameAppOperation gameAppOperation = new GameAppOperation(this.getQQToken());
        gameAppOperation.bindQQGroup(activity, bundle);
    }

    public void addToQQFavorites(Activity activity, Bundle bundle, IUiListener iUiListener) {
        GameAppOperation gameAppOperation = new GameAppOperation(this.getQQToken());
        gameAppOperation.addToQQFavorites(activity, bundle, iUiListener);
    }

    public void sendToMyComputer(Activity activity, Bundle bundle, IUiListener iUiListener) {
        GameAppOperation gameAppOperation = new GameAppOperation(this.getQQToken());
        gameAppOperation.sendToMyComputer(activity, bundle, iUiListener);
    }

    public void shareToTroopBar(Activity activity, Bundle bundle, IUiListener iUiListener) {
        GameAppOperation gameAppOperation = new GameAppOperation(this.getQQToken());
        gameAppOperation.shareToTroopBar(activity, bundle, iUiListener);
    }

    public int startWPAConversation(Activity activity, String string, String string2) {
        return this.startWPAConversation(activity, "wpa", string, string2);
    }

    public int startWPAConversation(Activity activity, String string, String string2, String string3) {
        f.c(TAG, "startWPAConversation()");
        WPA wPA = new WPA(this.getQQToken());
        return wPA.startWPAConversation(activity, string, string2, string3);
    }

    public void getWPAUserOnlineState(String string, IUiListener iUiListener) {
        f.c(TAG, "getWPAUserOnlineState()");
        WPA wPA = new WPA(this.getQQToken());
        wPA.getWPAUserOnlineState(string, iUiListener);
    }

    public int reactive(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "reactive()");
        SocialApi socialApi = new SocialApi(this.mQQAuth.getQQToken());
        socialApi.reactive(activity, bundle, iUiListener);
        return 0;
    }

    public int searchNearby(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "searchNearby()");
        if (this.mLocationApi == null) {
            this.mLocationApi = new LocationApi(this.mQQAuth.getQQToken());
        }
        this.mLocationApi.searchNearby(activity, bundle, iUiListener);
        return 0;
    }

    public int deleteLocation(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "deleteLocation()");
        if (this.mLocationApi == null) {
            this.mLocationApi = new LocationApi(this.mQQAuth.getQQToken());
        }
        this.mLocationApi.deleteLocation(activity, bundle, iUiListener);
        return 0;
    }

    public int brag(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "brag()");
        SocialApi socialApi = new SocialApi(this.mQQAuth.getQQToken());
        socialApi.brag(activity, bundle, iUiListener);
        return 0;
    }

    public int challenge(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "challenge()");
        SocialApi socialApi = new SocialApi(this.mQQAuth.getQQToken());
        socialApi.challenge(activity, bundle, iUiListener);
        return 0;
    }

    public void setAvatar(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "setAvatar()");
        String string = bundle.getString("picture");
        int n2 = bundle.getInt("exitAnim");
        QQAvatar qQAvatar = new QQAvatar(this.mQQAuth.getQQToken());
        qQAvatar.setAvatar(activity, Uri.parse((String)string), iUiListener, n2);
    }

    public void setAvatar(Activity activity, Bundle bundle, IUiListener iUiListener, int n2, int n3) {
        f.c(TAG, "setAvatar()");
        bundle.putInt("exitAnim", n3);
        activity.overridePendingTransition(n2, 0);
        this.setAvatar(activity, bundle, iUiListener);
    }

    public void grade(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "grade()");
        SocialApi socialApi = new SocialApi(this.mQQAuth.getQQToken());
        socialApi.grade(activity, bundle, iUiListener);
    }

    public void voice(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "voice()");
        SocialApi socialApi = new SocialApi(this.mQQAuth.getQQToken());
        socialApi.voice(activity, bundle, iUiListener);
    }

    public void showTaskGuideWindow(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "showTaskGuideWindow()");
        TaskGuide taskGuide = new TaskGuide((Context)activity, this.mQQAuth.getQQToken());
        taskGuide.showTaskGuideWindow(activity, bundle, iUiListener);
    }

    public void startAppbar(Activity activity, String string) {
        f.c(TAG, "startAppbar()");
        if (this.mAgent == null) {
            this.mAgent = new AppbarAgent(this.mQQAuth.getQQToken());
        }
        this.mAgent.startAppbar(activity, string);
    }

    public void startAppbarLabel(Activity activity, String string) {
        f.c(TAG, "startAppbarLabel()");
        if (this.mAgent == null) {
            this.mAgent = new AppbarAgent(this.mQQAuth.getQQToken());
        }
        this.mAgent.startAppbarLabel(activity, string);
    }

    public void sharePrizeToQQ(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "sharePrizeToQQ()");
        GameAppOperation gameAppOperation = new GameAppOperation(this.getQQToken());
        gameAppOperation.sharePrizeToQQ(activity, bundle, iUiListener);
    }

    public void queryUnexchangePrize(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "queryUnexchangePrize()");
        GameAppOperation gameAppOperation = new GameAppOperation(this.getQQToken());
        gameAppOperation.queryUnexchangePrize((Context)activity, bundle, iUiListener);
    }

    public void exchangePrize(Activity activity, Bundle bundle, IUiListener iUiListener) {
        f.c(TAG, "exchangePrize()");
        GameAppOperation gameAppOperation = new GameAppOperation(this.getQQToken());
        gameAppOperation.exchangePrize((Context)activity, bundle, iUiListener);
    }

    public void checkActivityAvailable(Activity activity, String string, IUiListener iUiListener) {
        f.c(TAG, "checkActivityAvailable()");
        GameAppOperation gameAppOperation = new GameAppOperation(this.getQQToken());
        gameAppOperation.isActivityAvailable(activity, string, iUiListener);
    }

    public boolean checkPrizeByIntent(Activity activity, Intent intent) {
        f.c(TAG, "checkPrizeByIntent()");
        boolean bl = false;
        if (intent == null) {
            f.e(TAG, "-->check by prize by intent, intent is null.");
        } else {
            bl = intent.getBooleanExtra("sharePrize", false);
        }
        return bl;
    }

    public void startAppbarThread(Activity activity, String string) {
        f.c(TAG, "startAppbarThread()");
        if (this.mAgent == null) {
            this.mAgent = new AppbarAgent(this.mQQAuth.getQQToken());
        }
        this.mAgent.startAppbarThread(activity, string);
    }

    public boolean joinQQGroup(Activity activity, String string) {
        f.c(TAG, "joinQQGroup()");
        Intent intent = new Intent();
        intent.setData(Uri.parse((String)("mqqopensdkapi://bizAgent/qm/qr?url=http%3A%2F%2Fqm.qq.com%2Fcgi-bin%2Fqm%2Fqr%3Ffrom%3Dapp%26p%3Dandroid%26k%3D" + string)));
        try {
            activity.startActivity(intent);
            d.a().a(this.mQQAuth.getQQToken().getOpenId(), this.mQQAuth.getQQToken().getAppId(), "ANDROIDQQ.JOININGROUP.XX", "13", "18", "0");
            return true;
        }
        catch (Exception exception) {
            d.a().a(this.mQQAuth.getQQToken().getOpenId(), this.mQQAuth.getQQToken().getAppId(), "ANDROIDQQ.JOININGROUP.XX", "13", "18", "1");
            return false;
        }
    }
}

