/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.media;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.tencent.mm.sdk.modelmsg.WXEmojiObject;
import com.tencent.mm.sdk.modelmsg.WXImageObject;
import com.tencent.mm.sdk.modelmsg.WXMediaMessage;
import com.tencent.mm.sdk.modelmsg.WXMusicObject;
import com.tencent.mm.sdk.modelmsg.WXTextObject;
import com.tencent.mm.sdk.modelmsg.WXVideoObject;
import com.tencent.mm.sdk.modelmsg.WXWebpageObject;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.media.UMEmoji;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMVideo;
import com.umeng.socialize.media.UMediaObject;
import com.umeng.socialize.media.UMusic;
import com.umeng.socialize.utils.BitmapUtils;
import com.umeng.socialize.utils.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;

public class WeiXinShareContent {
    private final String DEFAULT_TITLE = "\u5206\u4eab\u5230\u5fae\u4fe1";
    private WXMediaMessage mWxMediaMessage = null;
    private final int THUMB_SIZE = 150;
    private final int THUMB_LIMIT = 32768;
    private final int TITLE_LIMIT = 512;
    private final int DESCRIPTION_LIMIT = 1024;
    public String mShareType;
    private ShareContent mShareContent;
    private String mTitle;
    private String mTargetUrl;
    private final int SHOW_COMPRESS_TOAST = 1;
    private final int SHOW_TITLE_TOAST = 2;
    private String mText;
    private UMediaObject uMediaObject;
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_TEXT_IMAGE = "text_image";
    public static final String TYPE_VIDEO = "video";
    public static final String TYPE_MUSIC = "music";
    public static final String TYPE_EMOJI = "emoji";

    public WeiXinShareContent(ShareContent shareContent) {
        this.mShareContent = shareContent;
        this.mTitle = shareContent.mTitle;
        this.mText = shareContent.mText;
        this.uMediaObject = shareContent.mMedia;
        this.mTargetUrl = shareContent.mTargetUrl;
    }

    public void parseMediaType() {
        if (!TextUtils.isEmpty((CharSequence)this.mText) && this.uMediaObject == null) {
            this.mShareType = TYPE_TEXT;
        } else if (this.uMediaObject != null && this.uMediaObject instanceof UMEmoji) {
            this.mShareType = TYPE_EMOJI;
        } else if (TextUtils.isEmpty((CharSequence)this.mText) && this.uMediaObject != null && this.uMediaObject instanceof UMImage) {
            this.mShareType = TYPE_IMAGE;
        } else if (this.uMediaObject != null && this.uMediaObject instanceof UMusic) {
            this.mShareType = TYPE_MUSIC;
        } else if (this.uMediaObject != null && this.uMediaObject instanceof UMVideo) {
            this.mShareType = TYPE_VIDEO;
        } else if (!TextUtils.isEmpty((CharSequence)this.mText) && this.uMediaObject != null && this.uMediaObject instanceof UMImage) {
            this.mShareType = TYPE_TEXT_IMAGE;
        }
    }

    public WXMediaMessage getWxMediaMessage() {
        WXMediaMessage wxMessage = null;
        if (this.mShareContent.mMedia == null) {
            if (!TextUtils.isEmpty((CharSequence)this.mShareContent.mText)) {
                Log.i((String)"--->", (String)"text share..");
                wxMessage = this.buildTextParams();
            }
        } else if (this.mShareContent.mMedia instanceof UMEmoji) {
            wxMessage = this.buildEmojiParams();
        } else if (TextUtils.isEmpty((CharSequence)this.mShareContent.mText) && this.mShareContent.mMedia instanceof UMImage) {
            wxMessage = this.buildImageParams();
        } else if (this.mShareContent.mMedia instanceof UMusic) {
            wxMessage = this.buildMusicParams();
        } else if (this.mShareContent.mMedia instanceof UMVideo) {
            wxMessage = this.buildVideoParams();
        } else if (!TextUtils.isEmpty((CharSequence)this.mShareContent.mText) && this.mShareContent.mMedia instanceof UMImage) {
            Log.d((String)"\u56fe\u6587\u5206\u4eab..");
            wxMessage = this.buildTextImageParams();
        }
        if (wxMessage != null) {
            byte[] datas;
            byte[] thumbData = wxMessage.thumbData;
            if (thumbData != null && thumbData.length > 32768) {
                wxMessage.thumbData = this.compressBitmap(thumbData, 32768);
                Log.d((String)("\u538b\u7f29\u4e4b\u540e\u7f29\u7565\u56fe\u5927\u5c0f : " + wxMessage.thumbData.length / 1024 + " KB."));
            }
            if (!TextUtils.isEmpty((CharSequence)wxMessage.title) && wxMessage.title.getBytes().length >= 512) {
                datas = wxMessage.title.getBytes();
                wxMessage.title = new String(datas, 0, 512);
            } else {
                this.mTitle = "\u5206\u4eab\u5230\u5fae\u4fe1";
            }
            if (!TextUtils.isEmpty((CharSequence)wxMessage.description) && wxMessage.description.getBytes().length >= 1024) {
                datas = wxMessage.description.getBytes();
                wxMessage.description = new String(datas, 0, 1024);
            }
        }
        return wxMessage;
    }

    private byte[] compressBitmap(byte[] datas, int byteCount) {
        boolean isFinish = false;
        if (datas != null && datas.length >= byteCount) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Bitmap tmpBitmap = BitmapFactory.decodeByteArray((byte[])datas, (int)0, (int)datas.length);
            int times = 1;
            double percentage = 1.0;
            while (!isFinish && times <= 10) {
                percentage = Math.pow(0.8, times);
                int quality = (int)(100.0 * percentage);
                Log.d((String)("quality = " + quality));
                tmpBitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)outputStream);
                Log.d((String)("WeiXin Thumb Size = " + outputStream.toByteArray().length / 1024 + " KB"));
                if (outputStream != null && outputStream.size() < byteCount) {
                    isFinish = true;
                    continue;
                }
                outputStream.reset();
                ++times;
            }
            if (outputStream != null) {
                byte[] compress_datas = outputStream.toByteArray();
                if (!tmpBitmap.isRecycled()) {
                    tmpBitmap.recycle();
                }
                if (compress_datas != null && compress_datas.length <= 0) {
                    Log.e((String)"### \u60a8\u7684\u539f\u59cb\u56fe\u7247\u592a\u5927,\u5bfc\u81f4\u7f29\u7565\u56fe\u538b\u7f29\u8fc7\u540e\u8fd8\u5927\u4e8e32KB,\u8bf7\u5c06\u5206\u4eab\u5230\u5fae\u4fe1\u7684\u56fe\u7247\u8fdb\u884c\u9002\u5f53\u7f29\u5c0f.");
                }
                return compress_datas;
            }
        }
        return datas;
    }

    private WXMediaMessage buildEmojiParams() {
        UMEmoji emoji = (UMEmoji)this.mShareContent.mMedia;
        UMImage image = emoji.mSrcImage;
        String path = image.asFileImage().toString();
        WXEmojiObject wxEmojiObject = new WXEmojiObject();
        if (emoji.mSrcImage.isUrlMedia() && !new File(path = BitmapUtils.getFileName((String)image.toUrl())).exists()) {
            BitmapUtils.loadImage((String)image.toUrl(), (int)150, (int)150);
        }
        wxEmojiObject.emojiPath = path;
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = wxEmojiObject;
        if (emoji.getThumbImage() != null) {
            msg.thumbData = emoji.mThumb.toByte();
        } else if (!TextUtils.isEmpty((CharSequence)emoji.getThumb())) {
            Bitmap bitmap = BitmapUtils.loadImage((String)emoji.getThumb(), (int)150, (int)150);
            msg.thumbData = BitmapUtils.bitmap2Bytes((Bitmap)bitmap);
            bitmap.recycle();
        } else {
            msg.thumbData = emoji.mSrcImage.toByte();
        }
        msg.title = this.mTitle;
        msg.description = this.mShareContent.mText;
        return msg;
    }

    private WXMediaMessage buildMusicParams() {
        UMusic umusic = (UMusic)this.mShareContent.mMedia;
        WXMusicObject music = new WXMusicObject();
        music.musicUrl = TextUtils.isEmpty((CharSequence)umusic.getTargetUrl()) ? (TextUtils.isEmpty((CharSequence)this.mShareContent.mTargetUrl) ? umusic.toUrl() : umusic.toUrl()) : umusic.getTargetUrl();
        music.musicDataUrl = umusic.toUrl();
        WXMediaMessage msg = this.buildMediaMessage();
        msg.mediaObject = music;
        msg.title = TextUtils.isEmpty((CharSequence)umusic.getTitle()) ? (TextUtils.isEmpty((CharSequence)this.mShareContent.mTitle) ? "\u5206\u4eab\u97f3\u9891" : this.mShareContent.mTitle) : umusic.getTitle();
        msg.description = this.mShareContent.mText;
        msg.mediaObject = music;
        return msg;
    }

    private WXMediaMessage buildTextParams() {
        WXTextObject textObj = new WXTextObject();
        textObj.text = this.mShareContent.mText;
        WXMediaMessage msg = new WXMediaMessage();
        msg.mediaObject = textObj;
        msg.description = this.mShareContent.mText;
        msg.title = this.mTitle;
        return msg;
    }

    private WXMediaMessage buildImageParams() {
        UMImage img = (UMImage)this.mShareContent.mMedia;
        WXImageObject imgObj = new WXImageObject();
        WXMediaMessage msg = this.buildMediaMessage();
        if (!img.isUrlMedia()) {
            imgObj.imagePath = img.asFileImage().toString();
        } else {
            imgObj.imageUrl = img.asUrlImage();
        }
        imgObj.imageData = img.asBinImage();
        msg.mediaObject = imgObj;
        return msg;
    }

    private WXMediaMessage buildVideoParams() {
        UMVideo uvideo = (UMVideo)this.mShareContent.mMedia;
        WXVideoObject video = new WXVideoObject();
        video.videoUrl = uvideo.toUrl();
        WXMediaMessage msg = this.buildMediaMessage();
        msg.mediaObject = video;
        msg.title = TextUtils.isEmpty((CharSequence)this.mShareContent.mTitle) ? "\u5206\u4eab\u89c6\u9891" : this.mShareContent.mTitle;
        msg.description = this.mShareContent.mText;
        return msg;
    }

    private WXMediaMessage buildTextImageParams() {
        UMImage img = (UMImage)this.mShareContent.mMedia;
        if (TextUtils.isEmpty((CharSequence)this.mTargetUrl)) {
            this.mTargetUrl = "http://www.umeng.com/social";
        }
        WXWebpageObject webpage = new WXWebpageObject();
        webpage.webpageUrl = this.mTargetUrl;
        WXMediaMessage msg = this.buildMediaMessage();
        msg.title = this.mTitle;
        msg.description = this.mShareContent.mText;
        msg.mediaObject = webpage;
        return msg;
    }

    private WXMediaMessage buildMediaMessage() {
        UMImage icon;
        String localPath = null;
        String urlPath = null;
        if (this.mShareContent.mMedia instanceof UMImage) {
            UMImage umImage = (UMImage)this.mShareContent.mMedia;
            if (umImage.asFileImage() != null) {
                localPath = umImage.asFileImage().toString();
            } else {
                urlPath = umImage.asUrlImage();
            }
        } else if (this.mShareContent.mMedia instanceof UMVideo) {
            icon = ((UMVideo)this.mShareContent.mMedia).getThumbImage();
            if (icon != null) {
                if (icon != null && icon.asFileImage() != null) {
                    localPath = icon.asFileImage().toString();
                } else {
                    urlPath = icon.asUrlImage();
                }
            }
        } else if (this.mShareContent.mMedia instanceof UMusic && (icon = ((UMusic)this.mShareContent.mMedia).getThumbImage()) != null) {
            if (icon != null && icon.asFileImage() != null) {
                localPath = icon.asFileImage().toString();
            } else {
                urlPath = icon.asUrlImage();
            }
        }
        WXMediaMessage msg = new WXMediaMessage();
        if (!TextUtils.isEmpty((CharSequence)urlPath)) {
            msg.thumbData = BitmapUtils.bitmap2Bytes((Bitmap)BitmapUtils.loadImage((String)urlPath, (int)150, (int)150));
        } else if (!TextUtils.isEmpty((CharSequence)localPath)) {
            Bitmap thumb = this.getThumbFromCache(localPath);
            msg.thumbData = BitmapUtils.bitmap2Bytes((Bitmap)thumb);
            if (thumb != null && !thumb.isRecycled()) {
                thumb.recycle();
            }
        }
        return msg;
    }

    private Bitmap getThumbFromCache(String imgPath) {
        Bitmap bitmap = null;
        if (BitmapUtils.isFileExist((String)imgPath)) {
            bitmap = BitmapUtils.isNeedScale((String)imgPath, (int)32768) ? BitmapUtils.getBitmapFromFile((String)imgPath, (int)150, (int)150) : BitmapUtils.getBitmapFromFile((String)imgPath);
        }
        return bitmap;
    }
}

