/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.TextUtils;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.utils.Log;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class OauthHelper {
    private static final String TAG = "OauthHelper";
    private static final String QQ_KEY = "qq_sso";
    public static final String APP_ID = "appid";
    public static final String APP_KEY = "appkey";

    public static boolean isAuthenticated(Context context, SHARE_MEDIA sHARE_MEDIA) {
        if (context == null) {
            Log.w(TAG, "context\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u4f20\u9012\u4e00\u4e2a\u975e\u7a7aContext\u5bf9\u8c61");
            return false;
        }
        if (sHARE_MEDIA == null || sHARE_MEDIA == SHARE_MEDIA.GENERIC) {
            Log.w(TAG, "\u4f20\u9012\u7684\u68c0\u6d4b\u6388\u6743\u5e73\u53f0\u65e0\u6548");
            return false;
        }
        String string = OauthHelper.getUsid(context, sHARE_MEDIA);
        return !TextUtils.isEmpty((CharSequence)string);
    }

    public static boolean isAuthenticatedAndTokenNotExpired(Context context, SHARE_MEDIA sHARE_MEDIA) {
        if (!OauthHelper.isAuthenticated(context, sHARE_MEDIA)) {
            return false;
        }
        long l = OauthHelper.getTokenExpiresIn(context, sHARE_MEDIA);
        long l2 = System.currentTimeMillis() / 1000L;
        return l2 < l;
    }

    public static Map<SHARE_MEDIA, String> getAuthenticatedPlatform(Context context) {
        HashMap<SHARE_MEDIA, String> hashMap = new HashMap<SHARE_MEDIA, String>();
        try {
            SHARE_MEDIA[] sHARE_MEDIAArray;
            for (SHARE_MEDIA sHARE_MEDIA : sHARE_MEDIAArray = SHARE_MEDIA.getDefaultPlatform()) {
                if (OauthHelper.isAuthenticated(context, sHARE_MEDIA)) {
                    String string = OauthHelper.getUsid(context, sHARE_MEDIA);
                    hashMap.put(sHARE_MEDIA, string);
                    Log.i(TAG, "found platform " + sHARE_MEDIA.toString() + " usid=" + string);
                    continue;
                }
                Log.i(TAG, "No found oauthed platform " + sHARE_MEDIA.toString());
            }
            Log.i(TAG, "found platform count " + hashMap.size());
            return hashMap;
        }
        catch (NullPointerException nullPointerException) {
            Log.i(TAG, "no authenticated platform.......");
            return null;
        }
    }

    public static void saveTokenExpiresIn(Context context, SHARE_MEDIA sHARE_MEDIA, String string) {
        if (context == null) {
            Log.w(TAG, "context is null when save expires in");
            return;
        }
        String string2 = sHARE_MEDIA.toString();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.w(TAG, "platform is null when save expires in ");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        long l = 0L;
        try {
            l = Long.valueOf(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l <= 0L) {
            Log.w(TAG, string2 + " expires in is " + l);
            return;
        }
        long l2 = System.currentTimeMillis() / 1000L;
        SharedPreferences sharedPreferences = context.getSharedPreferences("umeng_socialize_token_expire_in", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(string2, l += l2);
        editor.commit();
    }

    public static long getTokenExpiresIn(Context context, SHARE_MEDIA sHARE_MEDIA) {
        long l = 0L;
        if (context == null) {
            Log.w(TAG, "context is null when obtain expires in");
            return l;
        }
        String string = sHARE_MEDIA.toString();
        if (TextUtils.isEmpty((CharSequence)string)) {
            Log.w(TAG, "platform is null when save expires in ");
            return l;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("umeng_socialize_token_expire_in", 0);
        l = sharedPreferences.getLong(string, 0L);
        return l;
    }

    public static void removeTokenExpiresIn(Context context, SHARE_MEDIA sHARE_MEDIA) {
        if (context == null) {
            Log.w(TAG, "context is null when removing expires in");
            return;
        }
        String string = sHARE_MEDIA.toString();
        if (TextUtils.isEmpty((CharSequence)string)) {
            Log.w(TAG, "platform is null when save expires in ");
            return;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("umeng_socialize_token_expire_in", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove(string);
        editor.commit();
    }

    public static String getUsid(Context context, SHARE_MEDIA sHARE_MEDIA) {
        if (sHARE_MEDIA == null) {
            return "";
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("umeng_socialize", 0);
        String string = sHARE_MEDIA.toString();
        String string2 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            string2 = sharedPreferences.getString(string, "");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUsid(Context context, SHARE_MEDIA sHARE_MEDIA, String string) {
        SharedPreferences sharedPreferences;
        SharedPreferences sharedPreferences2 = sharedPreferences = context.getSharedPreferences("umeng_socialize", 0);
        synchronized (sharedPreferences2) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            String string2 = sHARE_MEDIA.toString();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                editor.putString(string2, string);
                editor.commit();
                Log.d(TAG, "Save platform " + string2 + "   " + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAccessToken(Context context, SHARE_MEDIA sHARE_MEDIA, String string, String string2) {
        SharedPreferences sharedPreferences;
        SharedPreferences sharedPreferences2 = sharedPreferences = context.getSharedPreferences("umeng_socialize", 0);
        synchronized (sharedPreferences2) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            String string3 = sHARE_MEDIA.toString();
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                String string4 = string;
                String string5 = string2;
                editor.putString(string3 + "_ak", string4);
                editor.putString(string3 + "_as", string5);
                editor.commit();
            }
        }
    }

    public static String[] getAccessToken(Context context, SHARE_MEDIA sHARE_MEDIA) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("umeng_socialize", 0);
        String string = sHARE_MEDIA.toString();
        String string2 = string + "_ak";
        String string3 = string + "_as";
        if (sharedPreferences.contains(string2) && sharedPreferences.contains(string3)) {
            String string4 = sharedPreferences.getString(string2, "");
            String string5 = sharedPreferences.getString(string3, "");
            return new String[]{string4, string5};
        }
        return new String[0];
    }

    public static void saveQQAccessToken(Context context, JSONObject jSONObject) {
        String string = jSONObject.optString("access_token", "");
        String string2 = jSONObject.optString("openid", "");
        String string3 = jSONObject.optString("expires_in", "");
        OauthHelper.saveQQAccessToken(context, string, string2, string3);
    }

    public static void saveQQAccessToken(Context context, Bundle bundle) {
        String string = bundle.getString("access_token");
        String string2 = bundle.getString("openid");
        String string3 = bundle.getString("expires_in");
        OauthHelper.saveQQAccessToken(context, string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveQQAccessToken(Context context, String string, String string2, String string3) {
        SharedPreferences sharedPreferences;
        SharedPreferences sharedPreferences2 = sharedPreferences = context.getSharedPreferences("umeng_socialize_qq", 0);
        synchronized (sharedPreferences2) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            if (!TextUtils.isEmpty((CharSequence)string) || !TextUtils.isEmpty((CharSequence)string2)) {
                editor.putString("qq_sso_token", string);
                editor.putString("qq_sso_openid", string2);
                editor.putString("qq_sso_expires_in", OauthHelper.calExpireTime(string3));
                editor.commit();
                Log.d(TAG, "### Saved QQ Token.");
            }
        }
    }

    public static String[] getAccessTokenForQQ(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("umeng_socialize_qq", 0);
        String string = "qq_sso_token";
        String string2 = "qq_sso_openid";
        String string3 = "qq_sso_expires_in";
        if (sharedPreferences.contains(string) && sharedPreferences.contains(string2)) {
            String string4 = sharedPreferences.getString(string, "");
            String string5 = sharedPreferences.getString(string2, "");
            String string6 = sharedPreferences.getString(string3, "");
            Log.d(TAG, "get QQ Token." + string6);
            if (OauthHelper.isQQAuthExpired(string6)) {
                return null;
            }
            return new String[]{string4, string5, string6};
        }
        return null;
    }

    private static String calExpireTime(String string) {
        long l = System.currentTimeMillis() / 1000L + Long.parseLong(string);
        return String.valueOf(l);
    }

    public static boolean isQQAuthExpired(String string) {
        return System.currentTimeMillis() / 1000L >= Long.parseLong(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Context context, SHARE_MEDIA sHARE_MEDIA) {
        SharedPreferences sharedPreferences;
        SharedPreferences sharedPreferences2 = sharedPreferences = context.getSharedPreferences("umeng_socialize", 0);
        synchronized (sharedPreferences2) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.remove(sHARE_MEDIA.toString());
            editor.remove(sHARE_MEDIA.toString() + "_ak");
            editor.remove(sHARE_MEDIA.toString() + "_as");
            editor.commit();
            Log.d(TAG, "Remove platform " + sHARE_MEDIA.toString());
        }
        OauthHelper.deleteRefreshToken(context, sHARE_MEDIA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAppidAndAppkey(Context context, String string, String string2) {
        SharedPreferences sharedPreferences;
        SharedPreferences sharedPreferences2 = sharedPreferences = context.getSharedPreferences("umeng_socialize_qq", 0);
        synchronized (sharedPreferences2) {
            SharedPreferences.Editor editor = sharedPreferences.edit();
            editor.putString(APP_ID, string);
            editor.putString(string2, string2);
            editor.commit();
        }
    }

    public static Map<String, String> getAppIdAndAppkey(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("umeng_socialize_qq", 0);
        String string = sharedPreferences.getString(APP_ID, "");
        String string2 = sharedPreferences.getString(APP_KEY, "");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(APP_ID, string);
        hashMap.put(APP_KEY, string2);
        return hashMap;
    }

    public static void saveRefreshToken(Context context, SHARE_MEDIA sHARE_MEDIA, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("umeng_socialize_refresh_token", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(sHARE_MEDIA.toString(), string);
        editor.commit();
    }

    public static void deleteRefreshToken(Context context, SHARE_MEDIA sHARE_MEDIA) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("umeng_socialize_refresh_token", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove(sHARE_MEDIA.toString());
        editor.commit();
        SharedPreferences sharedPreferences2 = context.getSharedPreferences("umeng_socialize_refresh_token_expires", 0);
        SharedPreferences.Editor editor2 = sharedPreferences2.edit();
        editor2.remove(sHARE_MEDIA.toString());
        editor2.commit();
    }

    public static String getRefreshToken(Context context, SHARE_MEDIA sHARE_MEDIA) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("umeng_socialize_refresh_token", 0);
        return sharedPreferences.getString(sHARE_MEDIA.toString(), "");
    }

    public static void saveRefreshTokenExpires(Context context, SHARE_MEDIA sHARE_MEDIA, long l) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("umeng_socialize_refresh_token_expires", 0);
        long l2 = System.currentTimeMillis() / 1000L;
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong(sHARE_MEDIA.toString(), l += l2);
        editor.commit();
    }

    public static boolean isRefreshTokenNotExpired(Context context, SHARE_MEDIA sHARE_MEDIA) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("umeng_socialize_refresh_token_expires", 0);
        long l = System.currentTimeMillis() / 1000L;
        long l2 = sharedPreferences.getLong(sHARE_MEDIA.toString(), 0L);
        return l2 > l;
    }
}

