/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.sdk;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import com.sina.weibo.sdk.utils.LogUtil;
import com.sina.weibo.sdk.utils.MD5;

public class ApiUtils {
    private static final String TAG = ApiUtils.class.getName();
    public static final int BUILD_INT = 10350;
    public static final int BUILD_INT_VER_2_2 = 10351;
    public static final int BUILD_INT_VER_2_3 = 10352;
    public static final int BUILD_INT_VER_2_5 = 10353;
    public static final int BUILD_INT_440 = 10355;

    public static boolean validateWeiboSign(Context context, String pkgName) {
        PackageInfo packageInfo;
        if (TextUtils.isEmpty((CharSequence)pkgName)) {
            return false;
        }
        try {
            packageInfo = context.getPackageManager().getPackageInfo(pkgName, 64);
        }
        catch (PackageManager.NameNotFoundException localNameNotFoundException) {
            return false;
        }
        return ApiUtils.containSign(packageInfo.signatures, "18da2bf10352443a00a5e046d9fca6bd");
    }

    private static boolean containSign(Signature[] signatures, String destSign) {
        if (signatures == null || destSign == null) {
            return false;
        }
        Signature[] signatureArray = signatures;
        int n = signatures.length;
        int n2 = 0;
        while (n2 < n) {
            Signature signature = signatureArray[n2];
            String s = MD5.hexdigest(signature.toByteArray());
            if (destSign.equals(s)) {
                LogUtil.d(TAG, "check pass");
                return true;
            }
            ++n2;
        }
        return false;
    }
}

