/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.media;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import com.sina.weibo.sdk.api.ImageObject;
import com.sina.weibo.sdk.api.MusicObject;
import com.sina.weibo.sdk.api.TextObject;
import com.sina.weibo.sdk.api.VideoObject;
import com.sina.weibo.sdk.api.VoiceObject;
import com.sina.weibo.sdk.api.WebpageObject;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.sina.weibo.sdk.utils.Utility;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.common.ResContainer;
import com.umeng.socialize.media.SimpleShareContent;
import com.umeng.socialize.media.UMVideo;
import com.umeng.socialize.media.UMusic;
import com.umeng.socialize.utils.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class SinaShareContent
extends SimpleShareContent {
    private final int THUMB_LIMIT = 32768;
    private Context context;

    public SinaShareContent(ShareContent shareContent) {
        super(shareContent);
        if (shareContent.mMedia != null && shareContent.mMedia instanceof UMVideo) {
            this.setVideo((UMVideo)shareContent.mMedia);
        }
        if (shareContent.mMedia != null && shareContent.mMedia instanceof UMusic) {
            this.setMusic((UMusic)shareContent.mMedia);
        }
    }

    public void SetContext(Context mContext) {
        this.context = mContext;
    }

    public WeiboMultiMessage getMessage() {
        byte[] datas;
        WeiboMultiMessage weiboMessage = new WeiboMultiMessage();
        weiboMessage.textObject = this.getTextObj();
        if (this.getImage() != null) {
            weiboMessage.imageObject = this.getImageObj();
        }
        if (!TextUtils.isEmpty((CharSequence)this.getTargeturl())) {
            weiboMessage.mediaObject = this.getWebpageObj();
        }
        if (this.getMusic() != null) {
            weiboMessage.mediaObject = this.getMusicObj();
        }
        if (this.getVideo() != null) {
            weiboMessage.mediaObject = this.getVideoObj();
        }
        if (weiboMessage.imageObject != null && (datas = weiboMessage.imageObject.thumbData) != null && datas.length > 32768) {
            Log.d((String)"sinaxxxx", (String)("\u539f\u59cb\u7f29\u7565\u56fe\u5927\u5c0f : " + weiboMessage.imageObject.thumbData.length / 1024 + " KB."));
            weiboMessage.imageObject.thumbData = this.compressBitmap(datas, 32768);
            Log.d((String)"sinaxxxx ", (String)("\u538b\u7f29\u4e4b\u540e\u7f29\u7565\u56fe\u5927\u5c0f : " + weiboMessage.imageObject.thumbData.length / 1024 + " KB."));
        }
        return weiboMessage;
    }

    private TextObject getTextObj() {
        TextObject textObject = new TextObject();
        textObject.text = this.getText();
        return textObject;
    }

    private ImageObject getImageObj() {
        ImageObject imageObject = new ImageObject();
        if (this.getImage().asBitmap() != null) {
            imageObject.setImageObject(this.getImage().asBitmap());
        }
        return imageObject;
    }

    private WebpageObject getWebpageObj() {
        WebpageObject mediaObject = new WebpageObject();
        mediaObject.identify = Utility.generateGUID();
        mediaObject.title = TextUtils.isEmpty((CharSequence)this.getTitle()) ? "\u5206\u4eab\u89c6\u9891" : this.getTitle();
        mediaObject.description = this.getText();
        if (this.getImage() != null) {
            mediaObject.setThumbImage(this.getImage().asBitmap());
        } else {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)ResContainer.getResourceId((Context)this.context, (String)"drawable", (String)"sina_logo"));
            mediaObject.setThumbImage(bitmap);
        }
        mediaObject.actionUrl = this.getTargeturl();
        mediaObject.defaultText = this.getText();
        return mediaObject;
    }

    private MusicObject getMusicObj() {
        MusicObject musicObject = new MusicObject();
        musicObject.identify = Utility.generateGUID();
        musicObject.title = TextUtils.isEmpty((CharSequence)this.getTitle()) ? "\u5206\u4eab\u89c6\u9891" : this.getTitle();
        musicObject.description = this.getText();
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)ResContainer.getResourceId((Context)this.context, (String)"drawable", (String)"sina_logo"));
        musicObject.setThumbImage(bitmap);
        musicObject.actionUrl = this.getMusic().toUrl();
        musicObject.dataUrl = "www.umeng.com";
        musicObject.dataHdUrl = "www.umeng.com";
        musicObject.duration = 10;
        musicObject.defaultText = this.getText();
        return musicObject;
    }

    private VideoObject getVideoObj() {
        VideoObject videoObject = new VideoObject();
        videoObject.identify = Utility.generateGUID();
        videoObject.title = TextUtils.isEmpty((CharSequence)this.getTitle()) ? "\u5206\u4eab\u89c6\u9891" : this.getTitle();
        videoObject.description = this.getText();
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)ResContainer.getResourceId((Context)this.context, (String)"drawable", (String)"sina_logo"));
        videoObject.setThumbImage(bitmap);
        videoObject.actionUrl = this.getVideo().toUrl();
        videoObject.dataUrl = "www.umeng.com";
        videoObject.dataHdUrl = "www.umeng.com";
        videoObject.duration = 10;
        videoObject.defaultText = "Vedio \u9ed8\u8ba4\u6587\u6848";
        return videoObject;
    }

    private VoiceObject getVoiceObj() {
        return null;
    }

    private byte[] compressBitmap(byte[] datas, int byteCount) {
        boolean isFinish = false;
        if (datas != null && datas.length >= byteCount) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Bitmap tmpBitmap = BitmapFactory.decodeByteArray((byte[])datas, (int)0, (int)datas.length);
            int times = 1;
            double percentage = 1.0;
            while (!isFinish && times <= 10) {
                percentage = Math.pow(0.8, times);
                int quality = (int)(100.0 * percentage);
                tmpBitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)outputStream);
                if (outputStream != null && outputStream.size() < byteCount) {
                    isFinish = true;
                    continue;
                }
                outputStream.reset();
                ++times;
            }
            if (outputStream != null) {
                byte[] compress_datas = outputStream.toByteArray();
                if (!tmpBitmap.isRecycled()) {
                    tmpBitmap.recycle();
                }
                if (compress_datas == null || compress_datas.length <= 0) {
                    // empty if block
                }
                return compress_datas;
            }
        }
        return datas;
    }
}

